/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.config;

import io.sentry.Sentry;
import io.sentry.SentryOptions;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import lavalink.server.Launcher;
import lavalink.server.config.SentryConfigProperties;
import lavalink.server.config.SentryConfiguration;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\b\u0017\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\b\u0010\r\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Llavalink/server/config/SentryConfiguration;", "", "sentryConfig", "Llavalink/server/config/SentryConfigProperties;", "<init>", "(Llavalink/server/config/SentryConfigProperties;)V", "turnOn", "", "dsn", "", "tags", "", "environment", "turnOff", "Companion", "Lavalink-Server"})
@SourceDebugExtension(value={"SMAP\nSentryConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SentryConfiguration.kt\nlavalink/server/config/SentryConfiguration\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,91:1\n216#2,2:92\n*S KotlinDebug\n*F\n+ 1 SentryConfiguration.kt\nlavalink/server/config/SentryConfiguration\n*L\n45#1:92,2\n*E\n"})
public class SentryConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(SentryConfiguration.class);
    @NotNull
    private static final String SENTRY_APPENDER_NAME = "SENTRY";

    public SentryConfiguration(@NotNull SentryConfigProperties sentryConfig) {
        Intrinsics.checkNotNullParameter((Object)sentryConfig, (String)"sentryConfig");
        if (((CharSequence)sentryConfig.getDsn()).length() > 0) {
            this.turnOn(sentryConfig.getDsn(), sentryConfig.getTags(), sentryConfig.getEnvironment());
        } else {
            this.turnOff();
        }
    }

    private final void turnOn(String dsn, Map<String, String> tags, String environment) {
        log.info("Turning on sentry");
        Properties gitProps = new Properties();
        try {
            gitProps.load(Launcher.class.getClassLoader().getResourceAsStream("git.properties"));
        }
        catch (NullPointerException e) {
            log.error("Failed to load git repo information", (Throwable)e);
        }
        catch (IOException e) {
            log.error("Failed to load git repo information", (Throwable)e);
        }
        String commitHash = gitProps.getProperty("git.commit.id");
        Sentry.init(arg_0 -> SentryConfiguration.turnOn$lambda$1(dsn, environment, tags, commitHash, arg_0));
        Companion.access$getSentryLogbackAppender((Companion)Companion).start();
    }

    private final void turnOff() {
        log.warn("Turning off sentry");
        Sentry.close();
        Companion.access$getSentryLogbackAppender((Companion)Companion).stop();
    }

    private static final void turnOn$lambda$1(String $dsn, String $environment, Map $tags, String $commitHash, SentryOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        options.setDsn($dsn);
        if (!StringsKt.isBlank((CharSequence)$environment)) {
            options.setEnvironment($environment);
        }
        Map $this$forEach$iv = $tags;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            Map map = options.getTags();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getTags(...)");
            map.put(name, value);
        }
        if ($commitHash != null && ((CharSequence)$commitHash).length() > 0) {
            log.info("Setting sentry release to commit hash " + $commitHash);
            options.setRelease($commitHash);
        } else {
            log.warn("No git commit hash found to set up sentry release");
        }
    }
}

