/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.player;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.arbjerg.lavalink.api.AudioPluginInfoModifier;
import dev.arbjerg.lavalink.protocol.v4.LoadResult;
import dev.arbjerg.lavalink.protocol.v4.Track;
import dev.arbjerg.lavalink.protocol.v4.Tracks;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import lavalink.server.player.AudioLoaderRestHandler;
import lavalink.server.util.LoadingKt;
import lavalink.server.util.UtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@RestController
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0017J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u000fH\u0017J\u001f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\n2\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Llavalink/server/player/AudioLoaderRestHandler;", "", "audioPlayerManager", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "pluginInfoModifiers", "", "Ldev/arbjerg/lavalink/api/AudioPluginInfoModifier;", "<init>", "(Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;Ljava/util/List;)V", "loadTracks", "Lorg/springframework/http/ResponseEntity;", "Ldev/arbjerg/lavalink/protocol/v4/LoadResult;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "identifier", "", "getDecodeTrack", "Ldev/arbjerg/lavalink/protocol/v4/Track;", "encodedTrack", "track", "decodeTracks", "Ldev/arbjerg/lavalink/protocol/v4/Tracks;", "encodedTracks", "Ldev/arbjerg/lavalink/protocol/v4/EncodedTracks;", "decodeTracks-x8KJPTo", "(Ljava/util/ArrayList;)Lorg/springframework/http/ResponseEntity;", "Companion", "Lavalink-Server"})
@SourceDebugExtension(value={"SMAP\nAudioLoaderRestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioLoaderRestHandler.kt\nlavalink/server/player/AudioLoaderRestHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1563#2:121\n1634#2,3:122\n1563#2:125\n1634#2,3:126\n*S KotlinDebug\n*F\n+ 1 AudioLoaderRestHandler.kt\nlavalink/server/player/AudioLoaderRestHandler\n*L\n76#1:121\n76#1:122,3\n115#1:125\n115#1:126,3\n*E\n"})
public class AudioLoaderRestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AudioPlayerManager audioPlayerManager;
    @NotNull
    private final List<AudioPluginInfoModifier> pluginInfoModifiers;
    private static final Logger log = LoggerFactory.getLogger(AudioLoaderRestHandler.class);

    public AudioLoaderRestHandler(@NotNull AudioPlayerManager audioPlayerManager, @NotNull List<? extends AudioPluginInfoModifier> pluginInfoModifiers) {
        Intrinsics.checkNotNullParameter((Object)audioPlayerManager, (String)"audioPlayerManager");
        Intrinsics.checkNotNullParameter(pluginInfoModifiers, (String)"pluginInfoModifiers");
        this.audioPlayerManager = audioPlayerManager;
        this.pluginInfoModifiers = pluginInfoModifiers;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/v4/loadtracks"})
    @NotNull
    public ResponseEntity<LoadResult> loadTracks(@NotNull HttpServletRequest request, @RequestParam @NotNull String identifier) {
        LoadResult loadResult;
        AudioItem item;
        AudioItem audioItem;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        log.info("Got request to load for identifier \"" + identifier + "\"");
        try {
            audioItem = LoadingKt.loadAudioItem((AudioPlayerManager)this.audioPlayerManager, (String)identifier);
        }
        catch (FriendlyException ex) {
            log.error("Failed to load track for identifier " + identifier, (Throwable)ex);
            ResponseEntity responseEntity = ResponseEntity.ok((Object)UtilKt.loadFailed((LoadResult.Companion)LoadResult.Companion, (FriendlyException)ex));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
            return responseEntity;
        }
        AudioItem audioItem2 = item = audioItem;
        if (audioItem2 == null) {
            loadResult = (LoadResult)LoadResult.NoMatches.Companion.invoke();
        } else if (audioItem2 instanceof AudioTrack) {
            log.info("Loaded track " + ((AudioTrack)item).getInfo().title);
            loadResult = (LoadResult)LoadResult.Companion.trackLoaded(UtilKt.toTrack((AudioTrack)((AudioTrack)item), (AudioPlayerManager)this.audioPlayerManager, (List)this.pluginInfoModifiers));
        } else if (audioItem2 instanceof AudioPlaylist) {
            void $this$mapTo$iv$iv;
            log.info("Loaded playlist " + ((AudioPlaylist)item).getName());
            List list = ((AudioPlaylist)item).getTracks();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTracks(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AudioTrack audioTrack = (AudioTrack)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(UtilKt.toTrack((AudioTrack)it, (AudioPlayerManager)this.audioPlayerManager, (List)this.pluginInfoModifiers));
            }
            List tracks = (List)destination$iv$iv;
            loadResult = ((AudioPlaylist)item).isSearchResult() ? (LoadResult)LoadResult.Companion.searchResult(tracks) : (LoadResult)LoadResult.Companion.playlistLoaded(UtilKt.toPlaylistInfo((AudioPlaylist)((AudioPlaylist)item)), UtilKt.toPluginInfo((AudioPlaylist)((AudioPlaylist)item), (List)this.pluginInfoModifiers), tracks);
        } else {
            log.error("Unknown item type: " + item.getClass());
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Identifier returned unknown audio item type: " + item.getClass().getCanonicalName());
        }
        LoadResult result = loadResult;
        ResponseEntity responseEntity = ResponseEntity.ok((Object)result);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @GetMapping(value={"/v4/decodetrack"})
    @NotNull
    public ResponseEntity<Track> getDecodeTrack(@RequestParam @Nullable String encodedTrack, @RequestParam @Nullable String track) {
        String string = encodedTrack;
        if (string == null && (string = track) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "No track to decode provided");
        }
        String trackToDecode = string;
        ResponseEntity responseEntity = ResponseEntity.ok((Object)UtilKt.toTrack((AudioTrack)UtilKt.decodeTrack((AudioPlayerManager)this.audioPlayerManager, (String)trackToDecode), (String)trackToDecode, (List)this.pluginInfoModifiers));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/v4/decodetracks"})
    @NotNull
    public ResponseEntity<Tracks> decodeTracks-x8KJPTo(@RequestBody @NotNull ArrayList<String> encodedTracks) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(encodedTracks, (String)"encodedTracks");
        if (encodedTracks.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "No tracks to decode provided");
        }
        Iterable $this$map$iv = encodedTracks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UtilKt.toTrack((AudioTrack)UtilKt.decodeTrack((AudioPlayerManager)this.audioPlayerManager, (String)it), (String)it, (List)this.pluginInfoModifiers));
        }
        ResponseEntity responseEntity = ResponseEntity.ok((Object)Tracks.box-impl((List)Tracks.constructor-impl((List)((List)destination$iv$iv))));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }
}

