/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.config;

import com.sedmelluq.lava.common.natives.architecture.ArchitectureType;
import com.sedmelluq.lava.common.natives.architecture.DefaultArchitectureTypes;
import com.sedmelluq.lava.common.natives.architecture.DefaultOperatingSystemTypes;
import com.sedmelluq.lava.common.natives.architecture.OperatingSystemType;
import com.sedmelluq.lava.common.natives.architecture.SystemType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import lavalink.server.config.ServerConfig;
import moe.kyokobot.koe.KoeOptions;
import moe.kyokobot.koe.KoeOptionsBuilder;
import moe.kyokobot.koe.poller.FramePollerFactory;
import moe.kyokobot.koe.poller.udpqueue.QueueManagerPool;
import moe.kyokobot.koe.poller.udpqueue.UdpQueueFramePollerFactory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Llavalink/server/config/KoeConfiguration;", "", "serverConfig", "Llavalink/server/config/ServerConfig;", "<init>", "(Llavalink/server/config/ServerConfig;)V", "getServerConfig", "()Llavalink/server/config/ServerConfig;", "log", "Lorg/slf4j/Logger;", "supportedSystems", "", "Lcom/sedmelluq/lava/common/natives/architecture/SystemType;", "koeOptions", "Lmoe/kyokobot/koe/KoeOptions;", "Lavalink-Server"})
@SourceDebugExtension(value={"SMAP\nKoeConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KoeConfiguration.kt\nlavalink/server/config/KoeConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1761#2,3:82\n*S KotlinDebug\n*F\n+ 1 KoeConfiguration.kt\nlavalink/server/config/KoeConfiguration\n*L\n53#1:82,3\n*E\n"})
public class KoeConfiguration {
    @NotNull
    private final ServerConfig serverConfig;
    @NotNull
    private final Logger log;
    @NotNull
    private final List<SystemType> supportedSystems;

    public KoeConfiguration(@NotNull ServerConfig serverConfig) {
        Intrinsics.checkNotNullParameter((Object)serverConfig, (String)"serverConfig");
        this.serverConfig = serverConfig;
        Logger logger = LoggerFactory.getLogger(KoeConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.log = logger;
        Object[] objectArray = new SystemType[]{new SystemType((ArchitectureType)DefaultArchitectureTypes.ARM, (OperatingSystemType)DefaultOperatingSystemTypes.LINUX), new SystemType((ArchitectureType)DefaultArchitectureTypes.X86_64, (OperatingSystemType)DefaultOperatingSystemTypes.LINUX), new SystemType((ArchitectureType)DefaultArchitectureTypes.X86_32, (OperatingSystemType)DefaultOperatingSystemTypes.LINUX), new SystemType((ArchitectureType)DefaultArchitectureTypes.ARMv8_64, (OperatingSystemType)DefaultOperatingSystemTypes.LINUX), new SystemType((ArchitectureType)DefaultArchitectureTypes.X86_64, (OperatingSystemType)DefaultOperatingSystemTypes.LINUX_MUSL), new SystemType((ArchitectureType)DefaultArchitectureTypes.ARMv8_64, (OperatingSystemType)DefaultOperatingSystemTypes.LINUX_MUSL), new SystemType((ArchitectureType)DefaultArchitectureTypes.X86_64, (OperatingSystemType)DefaultOperatingSystemTypes.WINDOWS), new SystemType((ArchitectureType)DefaultArchitectureTypes.X86_32, (OperatingSystemType)DefaultOperatingSystemTypes.WINDOWS), new SystemType((ArchitectureType)DefaultArchitectureTypes.ARMv8_64, (OperatingSystemType)DefaultOperatingSystemTypes.WINDOWS), new SystemType((ArchitectureType)DefaultArchitectureTypes.X86_64, (OperatingSystemType)DefaultOperatingSystemTypes.DARWIN), new SystemType((ArchitectureType)DefaultArchitectureTypes.ARMv8_64, (OperatingSystemType)DefaultOperatingSystemTypes.DARWIN)};
        this.supportedSystems = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    @Bean
    @NotNull
    public KoeOptions koeOptions() {
        int bufferSize;
        Object object;
        SystemType systemType;
        Object object2;
        SystemType systemType2;
        KoeOptionsBuilder koeOptionsBuilder;
        KoeOptionsBuilder $this$koeOptions_u24lambda_u241 = koeOptionsBuilder = KoeOptions.builder();
        boolean bl = false;
        $this$koeOptions_u24lambda_u241.setDeafened(true);
        $this$koeOptions_u24lambda_u241.setEnableWSSPortOverride(false);
        try {
            systemType2 = new SystemType(DefaultArchitectureTypes.detect(), DefaultOperatingSystemTypes.detect());
        }
        catch (IllegalArgumentException e) {
            systemType2 = null;
        }
        if ((object2 = (systemType = systemType2)) == null || (object2 = object2.osType) == null) {
            object2 = "unknown";
        }
        if ((object = systemType) == null || (object = object.architectureType) == null) {
            object = "unknown";
        }
        this.log.info("OS: " + object2 + ", Arch: " + object);
        Integer n = this.getServerConfig().getBufferDurationMs();
        int n2 = bufferSize = n != null ? n : 400;
        if (bufferSize <= 0) {
            this.log.info("JDA-NAS is disabled! GC pauses may cause your bot to stutter during playback.");
        } else {
            boolean nasSupported;
            block14: {
                Iterable $this$any$iv = this.supportedSystems;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v4 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        SystemType it = (SystemType)element$iv;
                        boolean bl2 = false;
                        SystemType systemType3 = systemType;
                        if (!(Intrinsics.areEqual((Object)it.osType, (Object)(systemType3 != null ? systemType3.osType : null)) && Intrinsics.areEqual((Object)it.architectureType, (Object)systemType.architectureType))) continue;
                        v4 = true;
                        break block14;
                    }
                    v4 = nasSupported = false;
                }
            }
            if (nasSupported) {
                Unit unit;
                this.log.info("Enabling JDA-NAS");
                if (bufferSize < 40) {
                    this.log.warn("Buffer size of " + bufferSize + "ms is illegal. Defaulting to 400ms");
                    bufferSize = 400;
                }
                try {
                    unit = $this$koeOptions_u24lambda_u241.setFramePollerFactory((FramePollerFactory)new UdpQueueFramePollerFactory(new QueueManagerPool(Runtime.getRuntime().availableProcessors(), bufferSize)));
                }
                catch (Throwable e) {
                    this.log.warn("Failed to enable JDA-NAS! GC pauses may cause your bot to stutter during playback.", e);
                    unit = Unit.INSTANCE;
                }
            } else {
                this.log.warn("This system and architecture appears to not support native audio sending! GC pauses may cause your bot to stutter during playback.");
            }
        }
        KoeOptions koeOptions = koeOptionsBuilder.create();
        Intrinsics.checkNotNullExpressionValue((Object)koeOptions, (String)"create(...)");
        return koeOptions;
    }
}

