/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.io;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import dev.arbjerg.lavalink.api.AudioPluginInfoModifier;
import dev.arbjerg.lavalink.api.ISocketServer;
import dev.arbjerg.lavalink.api.PluginEventHandler;
import dev.arbjerg.lavalink.protocol.v4.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.random.Random;
import kotlin.ranges.CharRange;
import kotlinx.serialization.SerializationStrategy;
import lavalink.server.config.ServerConfig;
import lavalink.server.io.ShutdownHandler;
import lavalink.server.io.SocketContext;
import lavalink.server.io.SocketServer;
import lavalink.server.io.StatsCollector;
import moe.kyokobot.koe.Koe;
import moe.kyokobot.koe.KoeClient;
import moe.kyokobot.koe.KoeOptions;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 82\u00020\u00012\u00020\u0002:\u00018B;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\"\u001a\u00020\u0014H\u0012J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u0018\u0010+\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010/\u001a\u000200H\u0014J\u0015\u00101\u001a\u00020(2\u0006\u00102\u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\b3J\u0015\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u0014H\u0010\u00a2\u0006\u0002\b7R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u00069"}, d2={"Llavalink/server/io/SocketServer;", "Lorg/springframework/web/socket/handler/TextWebSocketHandler;", "Ldev/arbjerg/lavalink/api/ISocketServer;", "serverConfig", "Llavalink/server/config/ServerConfig;", "audioPlayerManager", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "koeOptions", "Lmoe/kyokobot/koe/KoeOptions;", "eventHandlers", "", "Ldev/arbjerg/lavalink/api/PluginEventHandler;", "pluginInfoModifiers", "Ldev/arbjerg/lavalink/api/AudioPluginInfoModifier;", "<init>", "(Llavalink/server/config/ServerConfig;Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;Lmoe/kyokobot/koe/KoeOptions;Ljava/util/List;Ljava/util/List;)V", "getAudioPlayerManager", "()Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "sessions", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Llavalink/server/io/SocketContext;", "getSessions", "()Ljava/util/concurrent/ConcurrentHashMap;", "resumableSessions", "", "getResumableSessions", "()Ljava/util/Map;", "koe", "Lmoe/kyokobot/koe/Koe;", "statsCollector", "Llavalink/server/io/StatsCollector;", "charPool", "", "generateUniqueSessionId", "contexts", "", "getContexts", "()Ljava/util/Collection;", "afterConnectionEstablished", "", "session", "Lorg/springframework/web/socket/WebSocketSession;", "afterConnectionClosed", "status", "Lorg/springframework/web/socket/CloseStatus;", "handleTextMessage", "message", "Lorg/springframework/web/socket/TextMessage;", "onSessionResumeTimeout", "context", "onSessionResumeTimeout$Lavalink_Server", "canResume", "", "id", "canResume$Lavalink_Server", "Companion", "Lavalink-Server"})
@SourceDebugExtension(value={"SMAP\nSocketServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocketServer.kt\nlavalink/server/io/SocketServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n1#2:183\n*E\n"})
public final class SocketServer
extends TextWebSocketHandler
implements ISocketServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerConfig serverConfig;
    @NotNull
    private final AudioPlayerManager audioPlayerManager;
    @NotNull
    private final List<PluginEventHandler> eventHandlers;
    @NotNull
    private final List<AudioPluginInfoModifier> pluginInfoModifiers;
    @NotNull
    private final ConcurrentHashMap<String, SocketContext> sessions;
    @NotNull
    private final Map<String, SocketContext> resumableSessions;
    @NotNull
    private final Koe koe;
    @NotNull
    private final StatsCollector statsCollector;
    @NotNull
    private final List<Character> charPool;
    private static final Logger log = LoggerFactory.getLogger(SocketServer.class);

    public SocketServer(@NotNull ServerConfig serverConfig, @NotNull AudioPlayerManager audioPlayerManager, @NotNull KoeOptions koeOptions, @NotNull List<? extends PluginEventHandler> eventHandlers, @NotNull List<? extends AudioPluginInfoModifier> pluginInfoModifiers) {
        Intrinsics.checkNotNullParameter((Object)serverConfig, (String)"serverConfig");
        Intrinsics.checkNotNullParameter((Object)audioPlayerManager, (String)"audioPlayerManager");
        Intrinsics.checkNotNullParameter((Object)koeOptions, (String)"koeOptions");
        Intrinsics.checkNotNullParameter(eventHandlers, (String)"eventHandlers");
        Intrinsics.checkNotNullParameter(pluginInfoModifiers, (String)"pluginInfoModifiers");
        this.serverConfig = serverConfig;
        this.audioPlayerManager = audioPlayerManager;
        this.eventHandlers = eventHandlers;
        this.pluginInfoModifiers = pluginInfoModifiers;
        this.sessions = new ConcurrentHashMap();
        this.resumableSessions = new LinkedHashMap();
        Koe koe = Koe.koe((KoeOptions)koeOptions);
        Intrinsics.checkNotNullExpressionValue((Object)koe, (String)"koe(...)");
        this.koe = koe;
        this.statsCollector = new StatsCollector(this);
        this.charPool = CollectionsKt.plus((Iterable)((Iterable)new CharRange('a', 'z')), (Iterable)((Iterable)new CharRange('0', '9')));
        Runtime.getRuntime().addShutdownHook((Thread)new ShutdownHandler(this));
    }

    @NotNull
    public AudioPlayerManager getAudioPlayerManager() {
        return this.audioPlayerManager;
    }

    @NotNull
    public ConcurrentHashMap<String, SocketContext> getSessions() {
        return this.sessions;
    }

    @NotNull
    public Map<String, SocketContext> getResumableSessions() {
        return this.resumableSessions;
    }

    private String generateUniqueSessionId() {
        String sessionId = null;
        do {
            int n = 16;
            ArrayList<Character> arrayList = new ArrayList<Character>(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                ArrayList<Character> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(Character.valueOf(((Character)CollectionsKt.random((Collection)this.charPool, (Random)((Random)Random.Default))).charValue()));
            }
            sessionId = CollectionsKt.joinToString$default((Iterable)arrayList, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        } while (this.getSessions().get(sessionId) != null);
        return sessionId;
    }

    @NotNull
    public Collection<SocketContext> getContexts() {
        Collection<SocketContext> collection = this.getSessions().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    public void afterConnectionEstablished(@NotNull WebSocketSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        String string = session.getHandshakeHeaders().getFirst("User-Id");
        Intrinsics.checkNotNull((Object)string);
        long userId = Long.parseLong(string);
        String sessionId = session.getHandshakeHeaders().getFirst("Session-Id");
        String clientName = session.getHandshakeHeaders().getFirst("Client-Name");
        String userAgent = session.getHandshakeHeaders().getFirst("User-Agent");
        SocketContext resumable = null;
        if (sessionId != null) {
            resumable = (SocketContext)this.getResumableSessions().remove(sessionId);
        }
        if (resumable != null) {
            Map map = session.getAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getAttributes(...)");
            Map map2 = map;
            String string2 = "sessionId";
            String string3 = resumable.getSessionId();
            map2.put(string2, string3);
            ((Map)this.getSessions()).put(resumable.getSessionId(), resumable);
            resumable.resume(session);
            log.info("Resumed session with id " + sessionId);
            resumable.getEventEmitter().onWebSocketOpen(true);
            return;
        }
        sessionId = this.generateUniqueSessionId();
        Map map = session.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getAttributes(...)");
        Map map3 = map;
        map3.put("sessionId", sessionId);
        AudioPlayerManager audioPlayerManager = this.getAudioPlayerManager();
        KoeClient koeClient = this.koe.newClient(userId);
        Intrinsics.checkNotNullExpressionValue((Object)koeClient, (String)"newClient(...)");
        SocketContext socketContext = new SocketContext(sessionId, audioPlayerManager, this.serverConfig, session, this, this.statsCollector, userId, clientName, koeClient, (Collection)this.eventHandlers, this.pluginInfoModifiers);
        ((Map)this.getSessions()).put(sessionId, socketContext);
        socketContext.sendMessage((SerializationStrategy)Message.Serializer, (Object)new Message.ReadyEvent(false, sessionId));
        socketContext.getEventEmitter().onWebSocketOpen(false);
        if (clientName != null) {
            log.info("Connection successfully established from " + clientName);
            return;
        }
        log.info("Connection successfully established");
        if (userAgent != null) {
            log.warn("Library developers: Please specify a 'Client-Name' header. User agent: " + userAgent);
        } else {
            log.warn("Library developers: Please specify a 'Client-Name' header.");
        }
    }

    public void afterConnectionClosed(@NotNull WebSocketSession session, @NotNull CloseStatus status) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Map map = this.getSessions();
        Object v = session.getAttributes().get("sessionId");
        SocketContext socketContext = (SocketContext)TypeIntrinsics.asMutableMap((Object)map).remove(v);
        if (socketContext == null) {
            return;
        }
        SocketContext context = socketContext;
        if (context.getResumable()) {
            SocketContext socketContext2 = (SocketContext)this.getResumableSessions().remove(context.getSessionId());
            if (socketContext2 != null) {
                SocketContext removed = socketContext2;
                boolean bl = false;
                log.warn("Shutdown resumable session with id " + removed.getSessionId() + " because it has the same id as a newly disconnected resumable session.");
                removed.shutdown$Lavalink_Server();
            }
            this.getResumableSessions().put(context.getSessionId(), context);
            context.pause();
            log.info("Connection closed from " + session.getRemoteAddress() + " with status " + status + " -- Session can be resumed within the next " + context.getResumeTimeout() + " seconds with id " + context.getSessionId());
            return;
        }
        log.info("Connection closed from " + session.getRemoteAddress() + " with id " + context.getSessionId() + " -- " + status);
        context.shutdown$Lavalink_Server();
    }

    protected void handleTextMessage(@NotNull WebSocketSession session, @NotNull TextMessage message) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        log.warn("Lavalink v4 does not support websocket messages. Please use the REST api.");
    }

    public void onSessionResumeTimeout$Lavalink_Server(@NotNull SocketContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.getResumableSessions().remove(context.getSessionId());
        context.shutdown$Lavalink_Server();
    }

    public boolean canResume$Lavalink_Server(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        SocketContext socketContext = (SocketContext)this.getResumableSessions().get(id);
        return socketContext != null ? socketContext.stopResumeTimeout() : false;
    }
}

