/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.io;

import jakarta.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import lavalink.server.config.RequestLoggingConfig;
import lavalink.server.io.RequestLoggingFilter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.AbstractRequestLoggingFilter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Llavalink/server/io/RequestLoggingFilter;", "Lorg/springframework/web/filter/AbstractRequestLoggingFilter;", "requestLoggingConfig", "Llavalink/server/config/RequestLoggingConfig;", "<init>", "(Llavalink/server/config/RequestLoggingConfig;)V", "beforeRequest", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "message", "", "afterRequest", "Companion", "Lavalink-Server"})
public final class RequestLoggingFilter
extends AbstractRequestLoggingFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RequestLoggingConfig requestLoggingConfig;
    private static final Logger log = LoggerFactory.getLogger(RequestLoggingFilter.class);

    public RequestLoggingFilter(@NotNull RequestLoggingConfig requestLoggingConfig) {
        Intrinsics.checkNotNullParameter((Object)requestLoggingConfig, (String)"requestLoggingConfig");
        this.requestLoggingConfig = requestLoggingConfig;
        this.setIncludeClientInfo(this.requestLoggingConfig.getIncludeClientInfo());
        this.setIncludeHeaders(this.requestLoggingConfig.getIncludeHeaders());
        this.setIncludeQueryString(this.requestLoggingConfig.getIncludeQueryString());
        this.setIncludePayload(this.requestLoggingConfig.getIncludePayload());
        this.setMaxPayloadLength(this.requestLoggingConfig.getMaxPayloadLength());
        this.setBeforeMessagePrefix(">> ");
        this.setBeforeMessageSuffix("");
        this.setAfterMessagePrefix("");
        this.setAfterMessageSuffix("");
    }

    protected void beforeRequest(@NotNull HttpServletRequest request, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!this.requestLoggingConfig.getBeforeRequest()) {
            return;
        }
        log.info(message);
    }

    protected void afterRequest(@NotNull HttpServletRequest request, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        log.info(message);
    }
}

