/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.io;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import lavalink.server.config.ServerConfig;
import lavalink.server.io.HandshakeInterceptorImpl;
import lavalink.server.io.SocketServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

@Controller
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J4\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0016J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0016\u001a\n\u0018\u00010\u0017j\u0004\u0018\u0001`\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Llavalink/server/io/HandshakeInterceptorImpl;", "Lorg/springframework/web/socket/server/HandshakeInterceptor;", "serverConfig", "Llavalink/server/config/ServerConfig;", "socketServer", "Llavalink/server/io/SocketServer;", "<init>", "(Llavalink/server/config/ServerConfig;Llavalink/server/io/SocketServer;)V", "beforeHandshake", "", "request", "Lorg/springframework/http/server/ServerHttpRequest;", "response", "Lorg/springframework/http/server/ServerHttpResponse;", "wsHandler", "Lorg/springframework/web/socket/WebSocketHandler;", "attributes", "", "", "", "afterHandshake", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Companion", "Lavalink-Server"})
public class HandshakeInterceptorImpl
implements HandshakeInterceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerConfig serverConfig;
    @NotNull
    private final SocketServer socketServer;
    private static final Logger log = LoggerFactory.getLogger(HandshakeInterceptorImpl.class);

    @Autowired
    public HandshakeInterceptorImpl(@NotNull ServerConfig serverConfig, @NotNull SocketServer socketServer) {
        Intrinsics.checkNotNullParameter((Object)serverConfig, (String)"serverConfig");
        Intrinsics.checkNotNullParameter((Object)socketServer, (String)"socketServer");
        this.serverConfig = serverConfig;
        this.socketServer = socketServer;
    }

    public boolean beforeHandshake(@NotNull ServerHttpRequest request, @NotNull ServerHttpResponse response, @NotNull WebSocketHandler wsHandler, @NotNull Map<String, ? extends Object> attributes) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Intrinsics.checkNotNullParameter((Object)wsHandler, (String)"wsHandler");
                Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
                String password = request.getHeaders().getFirst("Authorization");
                if (!Intrinsics.areEqual((Object)password, (Object)this.serverConfig.getPassword())) {
                    log.error("Authentication failed from " + request.getRemoteAddress());
                    response.setStatusCode((HttpStatusCode)HttpStatus.UNAUTHORIZED);
                    return false;
                }
                String userId = request.getHeaders().getFirst("User-Id");
                CharSequence charSequence = userId;
                if (charSequence == null || charSequence.length() == 0) break block4;
                Long l = StringsKt.toLongOrNull((String)userId);
                long l2 = 0L;
                if (l == null || l != l2) break block5;
            }
            log.error("Missing User-Id header from " + request.getRemoteAddress());
            response.setStatusCode((HttpStatusCode)HttpStatus.BAD_REQUEST);
            return false;
        }
        log.info("Incoming connection from " + request.getRemoteAddress());
        String sessionId = request.getHeaders().getFirst("Session-Id");
        boolean resuming = sessionId != null && this.socketServer.canResume$Lavalink_Server(sessionId);
        response.getHeaders().add("Session-Resumed", String.valueOf(resuming));
        return true;
    }

    public void afterHandshake(@NotNull ServerHttpRequest request, @NotNull ServerHttpResponse response, @NotNull WebSocketHandler wsHandler, @Nullable Exception exception) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)wsHandler, (String)"wsHandler");
    }
}

