/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.io;

import dev.arbjerg.lavalink.protocol.v4.Cpu;
import dev.arbjerg.lavalink.protocol.v4.FrameStats;
import dev.arbjerg.lavalink.protocol.v4.Memory;
import dev.arbjerg.lavalink.protocol.v4.Message;
import dev.arbjerg.lavalink.protocol.v4.Stats;
import dev.arbjerg.lavalink.protocol.v4.StatsData;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.SerializationStrategy;
import lavalink.server.Launcher;
import lavalink.server.io.SocketContext;
import lavalink.server.io.SocketServer;
import lavalink.server.io.StatsCollector;
import lavalink.server.player.AudioLossCounter;
import lavalink.server.player.LavalinkPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001d\u001a\u00020\u0017H\u0012J\b\u0010\u001e\u001a\u00020\u0017H\u0012J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0017J\u0014\u0010%\u001a\u00020$2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8RX\u0092\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u00100\u00108RX\u0092\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0001X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0001X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0019X\u0092\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Llavalink/server/io/StatsCollector;", "", "socketServer", "Llavalink/server/io/SocketServer;", "<init>", "(Llavalink/server/io/SocketServer;)V", "getSocketServer", "()Llavalink/server/io/SocketServer;", "si", "Loshi/SystemInfo;", "hal", "Loshi/hardware/HardwareAbstractionLayer;", "kotlin.jvm.PlatformType", "getHal", "()Loshi/hardware/HardwareAbstractionLayer;", "os", "Loshi/software/os/OperatingSystem;", "getOs", "()Loshi/software/os/OperatingSystem;", "prevTicks", "", "ticksLock", "cachedCpu", "Ldev/arbjerg/lavalink/protocol/v4/Cpu;", "lastCpuCalcTime", "", "cpuStatsCalculationLock", "prevUpTimeMs", "prevCpuTimeMs", "getOrUpdateCpuStats", "performCpuStatsCalculation", "createTask", "Ljava/lang/Runnable;", "context", "Llavalink/server/io/SocketContext;", "getStats", "Ldev/arbjerg/lavalink/protocol/v4/Stats;", "retrieveStats", "Companion", "Lavalink-Server"})
@SourceDebugExtension(value={"SMAP\nStatsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatsCollector.kt\nlavalink/server/io/StatsCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1#2:199\n1869#3,2:200\n*S KotlinDebug\n*F\n+ 1 StatsCollector.kt\nlavalink/server/io/StatsCollector\n*L\n145#1:200,2\n*E\n"})
public class StatsCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SocketServer socketServer;
    @NotNull
    private final SystemInfo si;
    @Nullable
    private long[] prevTicks;
    @NotNull
    private final Object ticksLock;
    @Nullable
    private volatile Cpu cachedCpu;
    private volatile long lastCpuCalcTime;
    @NotNull
    private final Object cpuStatsCalculationLock;
    private long prevUpTimeMs;
    private long prevCpuTimeMs;
    private static final Logger log = LoggerFactory.getLogger(StatsCollector.class);
    private static final int CPU_STATS_REFRESH_INTERVAL_MS = 30000;

    public StatsCollector(@NotNull SocketServer socketServer) {
        Intrinsics.checkNotNullParameter((Object)socketServer, (String)"socketServer");
        this.socketServer = socketServer;
        this.si = new SystemInfo();
        this.ticksLock = new Object();
        this.cpuStatsCalculationLock = new Object();
    }

    @NotNull
    public SocketServer getSocketServer() {
        return this.socketServer;
    }

    private HardwareAbstractionLayer getHal() {
        return this.si.getHardware();
    }

    private OperatingSystem getOs() {
        return this.si.getOperatingSystem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cpu getOrUpdateCpuStats() {
        Cpu currentCachedCpu = this.cachedCpu;
        long currentLastCalcTime = this.lastCpuCalcTime;
        if (currentCachedCpu != null && System.currentTimeMillis() - currentLastCalcTime <= 30000L) {
            return currentCachedCpu;
        }
        Object object = this.cpuStatsCalculationLock;
        synchronized (object) {
            boolean bl = false;
            if (this.cachedCpu == null || System.currentTimeMillis() - this.lastCpuCalcTime > 30000L) {
                this.cachedCpu = this.performCpuStatsCalculation();
                this.lastCpuCalcTime = System.currentTimeMillis();
            }
            Cpu cpu = this.cachedCpu;
            Intrinsics.checkNotNull((Object)cpu);
            Cpu cpu2 = cpu;
            return cpu2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cpu performCpuStatsCalculation() {
        double it;
        double systemLoad = 0.0;
        Object object = this.ticksLock;
        synchronized (object) {
            double d;
            boolean $i$a$-synchronized-StatsCollector$performCpuStatsCalculation$22 = false;
            long[] currentSystemTicks = this.getHal().getProcessor().getSystemCpuLoadTicks();
            if (this.prevTicks == null) {
                d = 0.0;
            } else {
                CentralProcessor centralProcessor = this.getHal().getProcessor();
                Intrinsics.checkNotNull((Object)this.prevTicks);
                d = centralProcessor.getSystemCpuLoadBetweenTicks(this.prevTicks);
            }
            systemLoad = d;
            this.prevTicks = currentSystemTicks;
            Unit $i$a$-synchronized-StatsCollector$performCpuStatsCalculation$22 = Unit.INSTANCE;
        }
        double processLoadNormalized = 0.0;
        OSProcess process = this.getOs().getProcess(this.getOs().getProcessId());
        if (process == null) {
            log.warn("Cannot calculate CPU load: process is null for PID {}.", (Object)this.getOs().getProcessId());
        } else {
            long currentProcessUptimeMs = process.getUpTime();
            long currentProcessTotalCpuTimeMs = process.getKernelTime() + process.getUserTime();
            if (this.prevUpTimeMs > 0L) {
                long uptimeDiffMs = currentProcessUptimeMs - this.prevUpTimeMs;
                long cpuTimeDiffMs = currentProcessTotalCpuTimeMs - this.prevCpuTimeMs;
                if (uptimeDiffMs > 0L) {
                    double singleCoreProcessLoad = (double)cpuTimeDiffMs / (double)uptimeDiffMs;
                    processLoadNormalized = singleCoreProcessLoad / (double)this.getHal().getProcessor().getLogicalProcessorCount();
                }
            }
            this.prevUpTimeMs = currentProcessUptimeMs;
            this.prevCpuTimeMs = currentProcessTotalCpuTimeMs;
        }
        Double d = RangesKt.coerceIn((double)systemLoad, (double)0.0, (double)1.0);
        double currentProcessTotalCpuTimeMs = ((Number)d).doubleValue();
        int n = this.getHal().getProcessor().getLogicalProcessorCount();
        boolean bl = false;
        boolean bl2 = Math.abs(it) <= Double.MAX_VALUE;
        Double d2 = bl2 ? d : null;
        d = RangesKt.coerceIn((double)processLoadNormalized, (double)0.0, (double)1.0);
        it = ((Number)d).doubleValue();
        double d3 = d2 != null ? d2 : 0.0;
        boolean bl3 = false;
        boolean bl4 = Math.abs(it) <= Double.MAX_VALUE;
        Double d4 = bl4 ? d : null;
        double d5 = d4 != null ? d4 : 0.0;
        double d6 = d3;
        int n2 = n;
        return new Cpu(n2, d6, d5);
    }

    @NotNull
    public Runnable createTask(@NotNull SocketContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return () -> StatsCollector.createTask$lambda$4(this, context);
    }

    @GetMapping(value={"/v4/stats"})
    @NotNull
    public Stats getStats() {
        return StatsCollector.retrieveStats$default((StatsCollector)this, null, (int)1, null);
    }

    @NotNull
    public Stats retrieveStats(@Nullable SocketContext context) {
        Cpu cpu = this.getOrUpdateCpuStats();
        int[] nArray = new int[]{0};
        int[] playersTotal = nArray;
        int[] nArray2 = new int[]{0};
        int[] playersPlaying = nArray2;
        Iterable $this$forEach$iv = this.getSocketServer().getContexts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SocketContext socketContext = (SocketContext)element$iv;
            boolean bl = false;
            playersTotal[0] = playersTotal[0] + socketContext.getPlayers().size();
            playersPlaying[0] = playersPlaying[0] + socketContext.getPlayingPlayers().size();
        }
        long uptime = System.currentTimeMillis() - Launcher.INSTANCE.getStartTime();
        Runtime runtime = Runtime.getRuntime();
        Memory mem = new Memory(runtime.freeMemory(), runtime.totalMemory() - runtime.freeMemory(), runtime.totalMemory(), runtime.maxMemory());
        FrameStats frameStats = null;
        if (context != null) {
            int playerCount = 0;
            int totalSent = 0;
            int totalNulled = 0;
            for (LavalinkPlayer player : context.getPlayingPlayers()) {
                AudioLossCounter counter = player.getAudioLossCounter();
                if (!counter.isDataUsable()) continue;
                ++playerCount;
                totalSent += counter.getLastMinuteSuccess();
                totalNulled += counter.getLastMinuteLoss();
            }
            if (playerCount != 0) {
                int totalDeficit = playerCount * 3000 - (totalSent + totalNulled);
                frameStats = new FrameStats(totalSent / playerCount, totalNulled / playerCount, totalDeficit / playerCount);
            }
        }
        return (Stats)new StatsData(frameStats, playersTotal[0], playersPlaying[0], uptime, mem, cpu);
    }

    public static /* synthetic */ Stats retrieveStats$default(StatsCollector statsCollector, SocketContext socketContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: retrieveStats");
        }
        if ((n & 1) != 0) {
            socketContext = null;
        }
        return statsCollector.retrieveStats(socketContext);
    }

    private static final void createTask$lambda$4(StatsCollector this$0, SocketContext $context) {
        try {
            Stats stats = this$0.retrieveStats($context);
            $context.sendMessage((SerializationStrategy)Message.Serializer, (Object)new Message.StatsEvent(stats));
        }
        catch (Exception e) {
            log.error("Exception while sending stats", (Throwable)e);
        }
    }
}

