/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import lavalink.server.config.MetricsPrometheusConfigProperties;
import lavalink.server.config.RequestAuthorizationFilter;
import lavalink.server.config.ServerConfig;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Llavalink/server/config/RequestAuthorizationFilter;", "Lorg/springframework/web/servlet/HandlerInterceptor;", "Lorg/springframework/web/servlet/config/annotation/WebMvcConfigurer;", "serverConfig", "Llavalink/server/config/ServerConfig;", "metricsConfig", "Llavalink/server/config/MetricsPrometheusConfigProperties;", "<init>", "(Llavalink/server/config/ServerConfig;Llavalink/server/config/MetricsPrometheusConfigProperties;)V", "preHandle", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "handler", "", "addInterceptors", "", "registry", "Lorg/springframework/web/servlet/config/annotation/InterceptorRegistry;", "Companion", "Lavalink-Server"})
public class RequestAuthorizationFilter
implements HandlerInterceptor,
WebMvcConfigurer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerConfig serverConfig;
    @NotNull
    private final MetricsPrometheusConfigProperties metricsConfig;
    private static final Logger log = LoggerFactory.getLogger(RequestAuthorizationFilter.class);

    public RequestAuthorizationFilter(@NotNull ServerConfig serverConfig, @NotNull MetricsPrometheusConfigProperties metricsConfig) {
        Intrinsics.checkNotNullParameter((Object)serverConfig, (String)"serverConfig");
        Intrinsics.checkNotNullParameter((Object)metricsConfig, (String)"metricsConfig");
        this.serverConfig = serverConfig;
        this.metricsConfig = metricsConfig;
    }

    public boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (((CharSequence)this.metricsConfig.getEndpoint()).length() > 0 && Intrinsics.areEqual((Object)request.getServletPath(), (Object)this.metricsConfig.getEndpoint())) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)request.getServletPath(), (Object)"/error")) {
            bl = true;
        } else {
            String authorization = request.getHeader("Authorization");
            if (authorization == null || !Intrinsics.areEqual((Object)authorization, (Object)this.serverConfig.getPassword())) {
                String string = request.getRequestURI();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequestURI(...)");
                String string2 = string;
                int n = request.getContextPath().length();
                String string3 = string2.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                String path = string3;
                if (authorization == null) {
                    log.warn("Authorization missing for " + request.getRemoteAddr() + " on " + request.getMethod() + " " + path);
                    response.setStatus(HttpStatus.UNAUTHORIZED.value());
                    return false;
                }
                log.warn("Authorization failed for " + request.getRemoteAddr() + " on " + request.getMethod() + " " + path);
                response.setStatus(HttpStatus.FORBIDDEN.value());
                return false;
            }
            return true;
        }
        return bl;
    }

    public void addInterceptors(@NotNull InterceptorRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        registry.addInterceptor((HandlerInterceptor)this);
    }
}

