/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.metrics;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import io.prometheus.client.hotspot.DefaultExports;
import io.prometheus.client.logback.InstrumentedAppender;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import lavalink.server.metrics.GcNotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"metrics.prometheus.enabled"})
public class PrometheusMetrics {
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetrics.class);

    public PrometheusMetrics() {
        InstrumentedAppender prometheusAppender = new InstrumentedAppender();
        LoggerContext factory = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger root = factory.getLogger("ROOT");
        prometheusAppender.setContext((Context)root.getLoggerContext());
        prometheusAppender.start();
        root.addAppender((Appender)prometheusAppender);
        DefaultExports.initialize();
        GcNotificationListener gcNotificationListener = new GcNotificationListener();
        for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(gcBean instanceof NotificationEmitter)) continue;
            ((NotificationEmitter)((Object)gcBean)).addNotificationListener((NotificationListener)gcNotificationListener, null, gcBean);
        }
        log.info("Prometheus metrics set up");
    }
}

