/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.metrics;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import lavalink.server.metrics.PrometheusMetrics;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${metrics.prometheus.endpoint:/metrics}"})
@ConditionalOnBean(value={PrometheusMetrics.class})
public class PrometheusMetricsController {
    private final CollectorRegistry registry = CollectorRegistry.defaultRegistry;

    @GetMapping(produces={"text/plain; version=0.0.4; charset=utf-8"})
    public ResponseEntity<String> getMetrics(@RequestParam(name="name[]", required=false) String[] includedParam) throws IOException {
        return this.buildAnswer(includedParam);
    }

    private ResponseEntity<String> buildAnswer(String[] includedParam) throws IOException {
        StringWriter writer;
        Set<Object> params = includedParam == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(includedParam));
        try (StringWriter stringWriter = writer = new StringWriter();){
            TextFormat.write004((Writer)writer, (Enumeration)this.registry.filteredMetricFamilySamples(params));
            ((Writer)writer).flush();
        }
        return new ResponseEntity((Object)((Object)writer).toString(), (HttpStatusCode)HttpStatus.OK);
    }
}

