/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.util;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.io.MessageInput;
import com.sedmelluq.discord.lavaplayer.tools.io.MessageOutput;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import dev.arbjerg.lavalink.api.AudioPluginInfoModifier;
import dev.arbjerg.lavalink.protocol.v4.Exception;
import dev.arbjerg.lavalink.protocol.v4.LoadResult;
import dev.arbjerg.lavalink.protocol.v4.Message;
import dev.arbjerg.lavalink.protocol.v4.Player;
import dev.arbjerg.lavalink.protocol.v4.PlayerState;
import dev.arbjerg.lavalink.protocol.v4.PlaylistInfo;
import dev.arbjerg.lavalink.protocol.v4.Track;
import dev.arbjerg.lavalink.protocol.v4.TrackInfo;
import dev.arbjerg.lavalink.protocol.v4.VoiceState;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonObject;
import lavalink.server.io.SocketContext;
import lavalink.server.io.SocketServer;
import lavalink.server.player.LavalinkPlayer;
import lavalink.server.util.UtilKt;
import moe.kyokobot.koe.MediaConnection;
import moe.kyokobot.koe.VoiceServerInfo;
import moe.kyokobot.koe.gateway.MediaGatewayConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.server.ResponseStatusException;

/*
 * Exception performing whole class analysis ignored.
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0096\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a\u0015\u0010\n\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0082\u0002\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0011\u001a\u0018\u0010\u0012\u001a\u00020\u000b*\u00020\u00112\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a \u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a\u0010\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019\u001a\u0016\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\t\u001a\u0016\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!\u001a\u0016\u0010\"\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\t\u001a\u0016\u0010$\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0002\u001a\u0012\u0010&\u001a\u00020'*\u00020(2\u0006\u0010)\u001a\u00020*\u001a\n\u0010+\u001a\u00020'*\u00020*\u001a\u0012\u0010&\u001a\u00020,*\u00020-2\u0006\u0010)\u001a\u00020.\u001a\n\u0010+\u001a\u00020/*\u000200\u001a\u0012\u00101\u001a\u000202*\u0002032\u0006\u00104\u001a\u00020.\u00a8\u00065"}, d2={"toTrack", "Ldev/arbjerg/lavalink/protocol/v4/Track;", "Lcom/sedmelluq/discord/lavaplayer/track/AudioTrack;", "audioPlayerManager", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "pluginInfoModifiers", "", "Ldev/arbjerg/lavalink/api/AudioPluginInfoModifier;", "encoded", "", "plus", "Lkotlinx/serialization/json/JsonObject;", "other", "toInfo", "Ldev/arbjerg/lavalink/protocol/v4/TrackInfo;", "toPlaylistInfo", "Ldev/arbjerg/lavalink/protocol/v4/PlaylistInfo;", "Lcom/sedmelluq/discord/lavaplayer/track/AudioPlaylist;", "toPluginInfo", "toPlayer", "Ldev/arbjerg/lavalink/protocol/v4/Player;", "Llavalink/server/player/LavalinkPlayer;", "context", "Llavalink/server/io/SocketContext;", "getRootCause", "", "throwable", "socketContext", "socketServer", "Llavalink/server/io/SocketServer;", "sessionId", "existingPlayer", "guildId", "", "decodeTrack", "message", "encodeTrack", "track", "fromFriendlyException", "Ldev/arbjerg/lavalink/protocol/v4/Exception$Severity;", "Ldev/arbjerg/lavalink/protocol/v4/Exception$Severity$Companion;", "e", "Lcom/sedmelluq/discord/lavaplayer/tools/FriendlyException$Severity;", "toLavalink", "Ldev/arbjerg/lavalink/protocol/v4/Exception;", "Ldev/arbjerg/lavalink/protocol/v4/Exception$Companion;", "Lcom/sedmelluq/discord/lavaplayer/tools/FriendlyException;", "Ldev/arbjerg/lavalink/protocol/v4/Message$EmittedEvent$TrackEndEvent$AudioTrackEndReason;", "Lcom/sedmelluq/discord/lavaplayer/track/AudioTrackEndReason;", "loadFailed", "Ldev/arbjerg/lavalink/protocol/v4/LoadResult$LoadFailed;", "Ldev/arbjerg/lavalink/protocol/v4/LoadResult$Companion;", "exception", "Lavalink-Server"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\nlavalink/server/util/UtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1803#2,3:173\n1803#2,3:176\n*S KotlinDebug\n*F\n+ 1 util.kt\nlavalink/server/util/UtilKt\n*L\n52#1:173,3\n84#1:176,3\n*E\n"})
public final class UtilKt {
    @NotNull
    public static final Track toTrack(@NotNull AudioTrack $this$toTrack, @NotNull AudioPlayerManager audioPlayerManager, @NotNull List<? extends AudioPluginInfoModifier> pluginInfoModifiers) {
        Intrinsics.checkNotNullParameter((Object)$this$toTrack, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)audioPlayerManager, (String)"audioPlayerManager");
        Intrinsics.checkNotNullParameter(pluginInfoModifiers, (String)"pluginInfoModifiers");
        return UtilKt.toTrack((AudioTrack)$this$toTrack, (String)UtilKt.encodeTrack((AudioPlayerManager)audioPlayerManager, (AudioTrack)$this$toTrack), pluginInfoModifiers);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Track toTrack(@NotNull AudioTrack $this$toTrack, @NotNull String encoded, @NotNull List<? extends AudioPluginInfoModifier> pluginInfoModifiers) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toTrack, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)encoded, (String)"encoded");
        Intrinsics.checkNotNullParameter(pluginInfoModifiers, (String)"pluginInfoModifiers");
        Iterable iterable = pluginInfoModifiers;
        JsonObject initial$iv = new JsonObject(MapsKt.emptyMap());
        boolean $i$f$fold = false;
        JsonObject accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void it;
            AudioPluginInfoModifier audioPluginInfoModifier = (AudioPluginInfoModifier)element$iv;
            JsonObject acc = accumulator$iv;
            boolean bl = false;
            JsonObject jsonObject = it.modifyAudioTrackPluginInfo($this$toTrack);
            if (jsonObject == null) {
                jsonObject = new JsonObject(MapsKt.emptyMap());
            }
            JsonObject jsonObject2 = jsonObject;
            accumulator$iv = UtilKt.plus((JsonObject)acc, (JsonObject)jsonObject2);
        }
        JsonObject pluginInfo = accumulator$iv;
        TrackInfo trackInfo = UtilKt.toInfo((AudioTrack)$this$toTrack);
        Object object = $this$toTrack.getUserData();
        JsonObject jsonObject = object instanceof JsonObject ? (JsonObject)object : null;
        if (jsonObject == null) {
            jsonObject = new JsonObject(MapsKt.emptyMap());
        }
        return new Track(encoded, trackInfo, pluginInfo, jsonObject);
    }

    private static final JsonObject plus(JsonObject $this$plus, JsonObject other) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        return new JsonObject(MapsKt.plus((Map)MapsKt.toMap((Map)((Map)$this$plus)), (Map)MapsKt.toMap((Map)((Map)other))));
    }

    @NotNull
    public static final TrackInfo toInfo(@NotNull AudioTrack $this$toInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$toInfo, (String)"<this>");
        String string = $this$toInfo.getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
        boolean bl = $this$toInfo.isSeekable();
        String string2 = $this$toInfo.getInfo().author;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"author");
        long l = $this$toInfo.getDuration();
        boolean bl2 = $this$toInfo.getInfo().isStream;
        long l2 = $this$toInfo.getPosition();
        String string3 = $this$toInfo.getInfo().title;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"title");
        String string4 = $this$toInfo.getInfo().uri;
        String string5 = $this$toInfo.getSourceManager().getSourceName();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getSourceName(...)");
        return new TrackInfo(string, bl, string2, l, bl2, l2, string3, string4, string5, $this$toInfo.getInfo().artworkUrl, $this$toInfo.getInfo().isrc);
    }

    @NotNull
    public static final PlaylistInfo toPlaylistInfo(@NotNull AudioPlaylist $this$toPlaylistInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$toPlaylistInfo, (String)"<this>");
        String string = $this$toPlaylistInfo.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new PlaylistInfo(string, $this$toPlaylistInfo.getSelectedTrack() == null ? -1 : $this$toPlaylistInfo.getTracks().indexOf($this$toPlaylistInfo.getSelectedTrack()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final JsonObject toPluginInfo(@NotNull AudioPlaylist $this$toPluginInfo, @NotNull List<? extends AudioPluginInfoModifier> pluginInfoModifiers) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toPluginInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter(pluginInfoModifiers, (String)"pluginInfoModifiers");
        Iterable iterable = pluginInfoModifiers;
        JsonObject initial$iv = new JsonObject(MapsKt.emptyMap());
        boolean $i$f$fold = false;
        JsonObject accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void it;
            AudioPluginInfoModifier audioPluginInfoModifier = (AudioPluginInfoModifier)element$iv;
            JsonObject acc = accumulator$iv;
            boolean bl = false;
            JsonObject jsonObject = it.modifyAudioPlaylistPluginInfo($this$toPluginInfo);
            if (jsonObject == null) {
                jsonObject = new JsonObject(MapsKt.emptyMap());
            }
            JsonObject jsonObject2 = jsonObject;
            accumulator$iv = UtilKt.plus((JsonObject)acc, (JsonObject)jsonObject2);
        }
        JsonObject pluginInfo = accumulator$iv;
        return pluginInfo;
    }

    @NotNull
    public static final Player toPlayer(@NotNull LavalinkPlayer $this$toPlayer, @NotNull SocketContext context, @NotNull List<? extends AudioPluginInfoModifier> pluginInfoModifiers) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)$this$toPlayer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(pluginInfoModifiers, (String)"pluginInfoModifiers");
        MediaGatewayConnection connection = context.getMediaConnection($this$toPlayer).getGatewayConnection();
        MediaConnection mediaConnection = context.getKoe().getConnection($this$toPlayer.getGuildId());
        VoiceServerInfo voiceServerInfo = mediaConnection != null ? mediaConnection.getVoiceServerInfo() : null;
        String string = String.valueOf($this$toPlayer.getGuildId());
        AudioTrack audioTrack = $this$toPlayer.getTrack();
        Track track = audioTrack != null ? UtilKt.toTrack((AudioTrack)audioTrack, (AudioPlayerManager)context.getAudioPlayerManager(), pluginInfoModifiers) : null;
        int n = $this$toPlayer.getAudioPlayer().getVolume();
        boolean bl = $this$toPlayer.getAudioPlayer().isPaused();
        AudioTrack audioTrack2 = $this$toPlayer.getTrack();
        MediaGatewayConnection mediaGatewayConnection = connection;
        MediaGatewayConnection mediaGatewayConnection2 = connection;
        PlayerState playerState = new PlayerState(System.currentTimeMillis(), audioTrack2 != null ? audioTrack2.getPosition() : 0L, mediaGatewayConnection != null ? mediaGatewayConnection.isOpen() : false, mediaGatewayConnection2 != null ? mediaGatewayConnection2.getPing() : -1L);
        Object object3 = voiceServerInfo;
        if (object3 == null || (object3 = object3.getToken()) == null) {
            object3 = "";
        }
        if ((object2 = voiceServerInfo) == null || (object2 = object2.getEndpoint()) == null) {
            object2 = "";
        }
        if ((object = voiceServerInfo) == null || (object = object.getSessionId()) == null) {
            object = "";
        }
        VoiceServerInfo voiceServerInfo2 = voiceServerInfo;
        return new Player(string, track, n, bl, playerState, new VoiceState((String)object3, (String)object2, (String)object, voiceServerInfo2 != null ? Long.valueOf(voiceServerInfo2.getChannelId()).toString() : null), $this$toPlayer.getFilters().toFilters());
    }

    @NotNull
    public static final Throwable getRootCause(@Nullable Throwable throwable) {
        Throwable rootCause = throwable;
        while (true) {
            Throwable throwable2 = rootCause;
            Intrinsics.checkNotNull((Object)throwable2);
            if (throwable2.getCause() == null) break;
            rootCause = rootCause.getCause();
        }
        return rootCause;
    }

    @NotNull
    public static final SocketContext socketContext(@NotNull SocketServer socketServer, @NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)socketServer, (String)"socketServer");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        SocketContext socketContext = (SocketContext)socketServer.getSessions().get(sessionId);
        if (socketContext == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Session not found");
        }
        return socketContext;
    }

    @NotNull
    public static final LavalinkPlayer existingPlayer(@NotNull SocketContext socketContext, long guildId) {
        Intrinsics.checkNotNullParameter((Object)socketContext, (String)"socketContext");
        LavalinkPlayer lavalinkPlayer = (LavalinkPlayer)socketContext.getPlayers().get(guildId);
        if (lavalinkPlayer == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Player not found");
        }
        return lavalinkPlayer;
    }

    @NotNull
    public static final AudioTrack decodeTrack(@NotNull AudioPlayerManager audioPlayerManager, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)audioPlayerManager, (String)"audioPlayerManager");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getDecoder().decode(message));
        AudioTrack audioTrack = audioPlayerManager.decodeTrack((MessageInput)new MessageInput((InputStream)((InputStream)bais))).decodedTrack;
        if (audioTrack == null) {
            throw new IllegalStateException("Failed to decode track due to a mismatching version or missing source manager");
        }
        return audioTrack;
    }

    @NotNull
    public static final String encodeTrack(@NotNull AudioPlayerManager audioPlayerManager, @NotNull AudioTrack track) {
        Intrinsics.checkNotNullParameter((Object)audioPlayerManager, (String)"audioPlayerManager");
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        audioPlayerManager.encodeTrack(new MessageOutput((OutputStream)baos), track);
        String string = Base64.getEncoder().encodeToString(baos.toByteArray());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return string;
    }

    @NotNull
    public static final Exception.Severity fromFriendlyException(@NotNull Exception.Severity.Companion $this$fromFriendlyException, @NotNull FriendlyException.Severity e) {
        Intrinsics.checkNotNullParameter((Object)$this$fromFriendlyException, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return switch (WhenMappings.$EnumSwitchMapping$0[e.ordinal()]) {
            case 1 -> Exception.Severity.COMMON;
            case 2 -> Exception.Severity.SUSPICIOUS;
            case 3 -> Exception.Severity.FAULT;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final Exception.Severity toLavalink(@NotNull FriendlyException.Severity $this$toLavalink) {
        Intrinsics.checkNotNullParameter((Object)$this$toLavalink, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toLavalink.ordinal()]) {
            case 1 -> Exception.Severity.COMMON;
            case 2 -> Exception.Severity.SUSPICIOUS;
            case 3 -> Exception.Severity.FAULT;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final Exception fromFriendlyException(@NotNull Exception.Companion $this$fromFriendlyException, @NotNull FriendlyException e) {
        Intrinsics.checkNotNullParameter((Object)$this$fromFriendlyException, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        String string = e.getMessage();
        FriendlyException.Severity severity = e.severity;
        Intrinsics.checkNotNullExpressionValue((Object)severity, (String)"severity");
        return new Exception(string, UtilKt.fromFriendlyException((Exception.Severity.Companion)Exception.Severity.Companion, (FriendlyException.Severity)severity), e.toString(), ExceptionsKt.stackTraceToString((Throwable)e));
    }

    @NotNull
    public static final Message.EmittedEvent.TrackEndEvent.AudioTrackEndReason toLavalink(@NotNull AudioTrackEndReason $this$toLavalink) {
        Intrinsics.checkNotNullParameter((Object)$this$toLavalink, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$toLavalink.ordinal()]) {
            case 1 -> Message.EmittedEvent.TrackEndEvent.AudioTrackEndReason.FINISHED;
            case 2 -> Message.EmittedEvent.TrackEndEvent.AudioTrackEndReason.LOAD_FAILED;
            case 3 -> Message.EmittedEvent.TrackEndEvent.AudioTrackEndReason.STOPPED;
            case 4 -> Message.EmittedEvent.TrackEndEvent.AudioTrackEndReason.REPLACED;
            case 5 -> Message.EmittedEvent.TrackEndEvent.AudioTrackEndReason.CLEANUP;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final LoadResult.LoadFailed loadFailed(@NotNull LoadResult.Companion $this$loadFailed, @NotNull FriendlyException exception) {
        Intrinsics.checkNotNullParameter((Object)$this$loadFailed, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)exception), (String)"exception");
        return $this$loadFailed.loadFailed(UtilKt.fromFriendlyException((Exception.Companion)Exception.Companion, (FriendlyException)exception));
    }
}

