/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.player;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventAdapter;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import dev.arbjerg.lavalink.api.AudioPluginInfoModifier;
import dev.arbjerg.lavalink.protocol.v4.Exception;
import dev.arbjerg.lavalink.protocol.v4.Message;
import dev.arbjerg.lavalink.protocol.v4.Track;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationStrategy;
import lavalink.server.io.SocketContext;
import lavalink.server.io.SocketServer;
import lavalink.server.player.EventEmitter;
import lavalink.server.player.LavalinkPlayer;
import lavalink.server.util.UtilKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Llavalink/server/player/EventEmitter;", "Lcom/sedmelluq/discord/lavaplayer/player/event/AudioEventAdapter;", "audioPlayerManager", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "player", "Llavalink/server/player/LavalinkPlayer;", "pluginInfoModifiers", "", "Ldev/arbjerg/lavalink/api/AudioPluginInfoModifier;", "<init>", "(Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;Llavalink/server/player/LavalinkPlayer;Ljava/util/List;)V", "onTrackStart", "", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayer;", "track", "Lcom/sedmelluq/discord/lavaplayer/track/AudioTrack;", "onTrackEnd", "endReason", "Lcom/sedmelluq/discord/lavaplayer/track/AudioTrackEndReason;", "onTrackException", "exception", "Lcom/sedmelluq/discord/lavaplayer/tools/FriendlyException;", "onTrackStuck", "thresholdMs", "", "Companion", "Lavalink-Server"})
public final class EventEmitter
extends AudioEventAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AudioPlayerManager audioPlayerManager;
    @NotNull
    private final LavalinkPlayer player;
    @NotNull
    private final List<AudioPluginInfoModifier> pluginInfoModifiers;
    private static final Logger log = LoggerFactory.getLogger(EventEmitter.class);

    public EventEmitter(@NotNull AudioPlayerManager audioPlayerManager, @NotNull LavalinkPlayer player, @NotNull List<? extends AudioPluginInfoModifier> pluginInfoModifiers) {
        Intrinsics.checkNotNullParameter((Object)audioPlayerManager, (String)"audioPlayerManager");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(pluginInfoModifiers, (String)"pluginInfoModifiers");
        this.audioPlayerManager = audioPlayerManager;
        this.player = player;
        this.pluginInfoModifiers = pluginInfoModifiers;
    }

    public void onTrackStart(@NotNull AudioPlayer player, @NotNull AudioTrack track) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        this.player.getSocketContext().sendMessage((SerializationStrategy)Message.Serializer, (Object)new Message.EmittedEvent.TrackStartEvent(String.valueOf(this.player.getGuildId()), UtilKt.toTrack((AudioTrack)track, (AudioPlayerManager)this.audioPlayerManager, (List)this.pluginInfoModifiers)));
    }

    public void onTrackEnd(@NotNull AudioPlayer player, @NotNull AudioTrack track, @NotNull AudioTrackEndReason endReason) {
        AudioTrackEndReason audioTrackEndReason;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        Intrinsics.checkNotNullParameter((Object)endReason, (String)"endReason");
        if (this.player.getEndMarkerHit()) {
            this.player.setEndMarkerHit(false);
            audioTrackEndReason = AudioTrackEndReason.FINISHED;
        } else {
            audioTrackEndReason = endReason;
        }
        AudioTrackEndReason reason = audioTrackEndReason;
        this.player.getSocketContext().sendMessage((SerializationStrategy)Message.Serializer, (Object)new Message.EmittedEvent.TrackEndEvent(String.valueOf(this.player.getGuildId()), UtilKt.toTrack((AudioTrack)track, (AudioPlayerManager)this.audioPlayerManager, (List)this.pluginInfoModifiers), UtilKt.toLavalink((AudioTrackEndReason)reason)));
    }

    public void onTrackException(@NotNull AudioPlayer player, @NotNull AudioTrack track, @NotNull FriendlyException exception) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        Intrinsics.checkNotNullParameter((Object)((Object)exception), (String)"exception");
        Throwable rootCause = UtilKt.getRootCause((Throwable)exception);
        SocketContext socketContext = this.player.getSocketContext();
        SerializationStrategy serializationStrategy = (SerializationStrategy)Message.Serializer;
        String string = String.valueOf(this.player.getGuildId());
        Track track2 = UtilKt.toTrack((AudioTrack)track, (AudioPlayerManager)this.audioPlayerManager, (List)this.pluginInfoModifiers);
        String string2 = exception.getMessage();
        FriendlyException.Severity severity = exception.severity;
        Intrinsics.checkNotNullExpressionValue((Object)severity, (String)"severity");
        socketContext.sendMessage(serializationStrategy, (Object)new Message.EmittedEvent.TrackExceptionEvent(string, track2, new Exception(string2, UtilKt.toLavalink((FriendlyException.Severity)severity), rootCause.toString(), ExceptionsKt.stackTraceToString((Throwable)rootCause))));
    }

    public void onTrackStuck(@NotNull AudioPlayer player, @NotNull AudioTrack track, long thresholdMs) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        log.warn(track.getInfo().title + " got stuck! Threshold surpassed: " + thresholdMs + "ms");
        this.player.getSocketContext().sendMessage((SerializationStrategy)Message.Serializer, (Object)new Message.EmittedEvent.TrackStuckEvent(String.valueOf(this.player.getGuildId()), UtilKt.toTrack((AudioTrack)track, (AudioPlayerManager)this.audioPlayerManager, (List)this.pluginInfoModifiers), thresholdMs));
        SocketServer.Companion.sendPlayerUpdate(this.player.getSocketContext(), this.player);
    }
}

