/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.metrics;

import dev.arbjerg.lavalink.protocol.v4.Cpu;
import dev.arbjerg.lavalink.protocol.v4.Memory;
import dev.arbjerg.lavalink.protocol.v4.Stats;
import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import lavalink.server.io.StatsCollector;
import lavalink.server.metrics.LavalinkStatsCollector;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"metrics.prometheus.enabled"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u000b2\u00020\u00012\u00020\u0002:\u0001\u000bB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Llavalink/server/metrics/LavalinkStatsCollector;", "Lio/prometheus/client/Collector;", "Lio/prometheus/client/Collector$Describable;", "statsProvider", "Llavalink/server/io/StatsCollector;", "<init>", "(Llavalink/server/io/StatsCollector;)V", "collect", "", "Lio/prometheus/client/Collector$MetricFamilySamples;", "describe", "Companion", "Lavalink-Server"})
public class LavalinkStatsCollector
extends Collector
implements Collector.Describable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StatsCollector statsProvider;
    private static final Logger log = LoggerFactory.getLogger(LavalinkStatsCollector.class);
    @NotNull
    private static final String PREFIX = "lavalink_";
    @NotNull
    private static final String PLAYERS_METRIC_NAME = "lavalink_players_total";
    @NotNull
    private static final String PLAYERS_HELP = "Total number of players connected.";
    @NotNull
    private static final String PLAYING_PLAYERS_METRIC_NAME = "lavalink_playing_players_total";
    @NotNull
    private static final String PLAYING_PLAYERS_HELP = "Number of players currently playing audio.";
    @NotNull
    private static final String UPTIME_METRIC_NAME = "lavalink_uptime_milliseconds";
    @NotNull
    private static final String UPTIME_HELP = "Uptime of the node in milliseconds.";
    @NotNull
    private static final String MEMORY_FREE_METRIC_NAME = "lavalink_memory_free_bytes";
    @NotNull
    private static final String MEMORY_USED_METRIC_NAME = "lavalink_memory_used_bytes";
    @NotNull
    private static final String MEMORY_ALLOCATED_METRIC_NAME = "lavalink_memory_allocated_bytes";
    @NotNull
    private static final String MEMORY_RESERVABLE_METRIC_NAME = "lavalink_memory_reservable_bytes";
    @NotNull
    private static final String MEMORY_HELP = "Memory statistics in bytes.";
    @NotNull
    private static final String CPU_CORES_METRIC_NAME = "lavalink_cpu_cores";
    @NotNull
    private static final String CPU_SYSTEM_LOAD_METRIC_NAME = "lavalink_cpu_system_load_percentage";
    @NotNull
    private static final String CPU_LAVALINK_LOAD_METRIC_NAME = "lavalink_cpu_lavalink_load_percentage";
    @NotNull
    private static final String CPU_HELP = "CPU statistics.";

    public LavalinkStatsCollector(@NotNull StatsCollector statsProvider) {
        Intrinsics.checkNotNullParameter((Object)statsProvider, (String)"statsProvider");
        this.statsProvider = statsProvider;
        this.register();
        log.info("Lavalink custom stats collector registered with Prometheus.");
    }

    @NotNull
    public List<Collector.MetricFamilySamples> collect() {
        Stats stats = this.statsProvider.retrieveStats(null);
        Memory memory = stats.getMemory();
        Cpu cpu = stats.getCpu();
        Object[] objectArray = new Collector.MetricFamilySamples[]{new GaugeMetricFamily(PLAYERS_METRIC_NAME, PLAYERS_HELP, (double)stats.getPlayers()), new GaugeMetricFamily(PLAYING_PLAYERS_METRIC_NAME, PLAYING_PLAYERS_HELP, (double)stats.getPlayingPlayers()), new GaugeMetricFamily(UPTIME_METRIC_NAME, UPTIME_HELP, (double)stats.getUptime()), new GaugeMetricFamily(MEMORY_FREE_METRIC_NAME, "Memory statistics in bytes. (Free)", (double)memory.getFree()), new GaugeMetricFamily(MEMORY_USED_METRIC_NAME, "Memory statistics in bytes. (Used)", (double)memory.getUsed()), new GaugeMetricFamily(MEMORY_ALLOCATED_METRIC_NAME, "Memory statistics in bytes. (Allocated)", (double)memory.getAllocated()), new GaugeMetricFamily(MEMORY_RESERVABLE_METRIC_NAME, "Memory statistics in bytes. (Reservable)", (double)memory.getReservable()), new GaugeMetricFamily(CPU_CORES_METRIC_NAME, "CPU statistics. (Cores)", (double)cpu.getCores()), new GaugeMetricFamily(CPU_SYSTEM_LOAD_METRIC_NAME, "CPU statistics. (System Load)", cpu.getSystemLoad()), new GaugeMetricFamily(CPU_LAVALINK_LOAD_METRIC_NAME, "CPU statistics. (LL Load)", cpu.getLavalinkLoad())};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    public List<Collector.MetricFamilySamples> describe() {
        Object[] objectArray = new Collector.MetricFamilySamples[]{new GaugeMetricFamily(PLAYERS_METRIC_NAME, PLAYERS_HELP, (List)new ArrayList()), new GaugeMetricFamily(PLAYING_PLAYERS_METRIC_NAME, PLAYING_PLAYERS_HELP, (List)new ArrayList()), new GaugeMetricFamily(UPTIME_METRIC_NAME, UPTIME_HELP, (List)new ArrayList()), new GaugeMetricFamily(MEMORY_FREE_METRIC_NAME, "Memory statistics in bytes. (Free)", (List)new ArrayList()), new GaugeMetricFamily(MEMORY_USED_METRIC_NAME, "Memory statistics in bytes. (Used)", (List)new ArrayList()), new GaugeMetricFamily(MEMORY_ALLOCATED_METRIC_NAME, "Memory statistics in bytes. (Allocated)", (List)new ArrayList()), new GaugeMetricFamily(MEMORY_RESERVABLE_METRIC_NAME, "Memory statistics in bytes. (Reservable)", (List)new ArrayList()), new GaugeMetricFamily(CPU_CORES_METRIC_NAME, "CPU statistics. (Cores)", (List)new ArrayList()), new GaugeMetricFamily(CPU_SYSTEM_LOAD_METRIC_NAME, "CPU statistics. (System Load)", (List)new ArrayList()), new GaugeMetricFamily(CPU_LAVALINK_LOAD_METRIC_NAME, "CPU statistics. (Lavalink Load)", (List)new ArrayList())};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }
}

