/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.io;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import dev.arbjerg.lavalink.api.AudioPluginInfoModifier;
import dev.arbjerg.lavalink.api.IPlayer;
import dev.arbjerg.lavalink.api.ISocketContext;
import dev.arbjerg.lavalink.api.PluginEventHandler;
import dev.arbjerg.lavalink.protocol.v4.Mapper;
import dev.arbjerg.lavalink.protocol.v4.Message;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.jsr.UndertowSession;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import lavalink.server.config.ServerConfig;
import lavalink.server.io.EventEmitter;
import lavalink.server.io.SocketContext;
import lavalink.server.io.SocketServer;
import lavalink.server.io.StatsCollector;
import lavalink.server.player.LavalinkPlayer;
import moe.kyokobot.koe.KoeClient;
import moe.kyokobot.koe.KoeEventListener;
import moe.kyokobot.koe.MediaConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.adapter.standard.StandardWebSocketSession;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 c2\u00020\u0001:\u0002cdBm\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010K\u001a\u00020&2\u0006\u0010L\u001a\u00020\u000fH\u0016J\u000e\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020&J\u0010\u0010P\u001a\u00020>2\u0006\u0010L\u001a\u00020\u000fH\u0016J\u0006\u0010Q\u001a\u00020>J/\u0010R\u001a\u00020>\"\n\b\u0000\u0010S*\u0004\u0018\u00010T2\f\u0010U\u001a\b\u0012\u0004\u0012\u0002HS0V2\u0006\u0010W\u001a\u0002HSH\u0016\u00a2\u0006\u0002\u0010XJ\u0010\u0010Y\u001a\u00020>2\u0006\u0010Z\u001a\u00020\u0003H\u0002J\u0006\u0010[\u001a\u00020.J\u000e\u0010\\\u001a\u00020>2\u0006\u0010\b\u001a\u00020\tJ\r\u0010]\u001a\u00020>H\u0000\u00a2\u0006\u0002\b^J\u001a\u0010_\u001a\u00020>2\u0006\u0010`\u001a\u00020a2\b\u0010b\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010_\u001a\u00020>2\u0006\u0010`\u001a\u00020aH\u0016J\b\u0010_\u001a\u00020>H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001cR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020&0%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\u000304X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00105\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00100\"\u0004\b7\u00102R\u001a\u00108\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010 \"\u0004\b:\u0010;R\u0016\u0010<\u001a\n\u0012\u0004\u0012\u00020>\u0018\u00010=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010A\u001a\u00020@\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0014\u0010D\u001a\u00020E8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR\u0017\u0010H\u001a\b\u0012\u0004\u0012\u00020&0\u00178F\u00a2\u0006\u0006\u001a\u0004\bI\u0010J\u00a8\u0006e"}, d2={"Llavalink/server/io/SocketContext;", "Ldev/arbjerg/lavalink/api/ISocketContext;", "sessionId", "", "audioPlayerManager", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "serverConfig", "Llavalink/server/config/ServerConfig;", "session", "Lorg/springframework/web/socket/WebSocketSession;", "socketServer", "Llavalink/server/io/SocketServer;", "statsCollector", "Llavalink/server/io/StatsCollector;", "userId", "", "clientName", "koe", "Lmoe/kyokobot/koe/KoeClient;", "eventHandlers", "", "Ldev/arbjerg/lavalink/api/PluginEventHandler;", "pluginInfoModifiers", "", "Ldev/arbjerg/lavalink/api/AudioPluginInfoModifier;", "<init>", "(Ljava/lang/String;Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;Llavalink/server/config/ServerConfig;Lorg/springframework/web/socket/WebSocketSession;Llavalink/server/io/SocketServer;Llavalink/server/io/StatsCollector;JLjava/lang/String;Lmoe/kyokobot/koe/KoeClient;Ljava/util/Collection;Ljava/util/List;)V", "getSessionId", "()Ljava/lang/String;", "getAudioPlayerManager", "()Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "getUserId", "()J", "getClientName", "getKoe", "()Lmoe/kyokobot/koe/KoeClient;", "players", "Ljava/util/concurrent/ConcurrentHashMap;", "Llavalink/server/player/LavalinkPlayer;", "getPlayers", "()Ljava/util/concurrent/ConcurrentHashMap;", "eventEmitter", "Llavalink/server/io/EventEmitter;", "getEventEmitter", "()Llavalink/server/io/EventEmitter;", "sessionPaused", "", "getSessionPaused", "()Z", "setSessionPaused", "(Z)V", "resumeEventQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "resumable", "getResumable", "setResumable", "resumeTimeout", "getResumeTimeout", "setResumeTimeout", "(J)V", "sessionTimeoutFuture", "Ljava/util/concurrent/ScheduledFuture;", "", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "playerUpdateService", "getPlayerUpdateService", "()Ljava/util/concurrent/ScheduledExecutorService;", "state", "Ldev/arbjerg/lavalink/api/ISocketContext$State;", "getState", "()Ldev/arbjerg/lavalink/api/ISocketContext$State;", "playingPlayers", "getPlayingPlayers", "()Ljava/util/List;", "getPlayer", "guildId", "getMediaConnection", "Lmoe/kyokobot/koe/MediaConnection;", "player", "destroyPlayer", "pause", "sendMessage", "T", "", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "message", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "send", "payload", "stopResumeTimeout", "resume", "shutdown", "shutdown$Lavalink_Server", "closeWebSocket", "closeCode", "", "reason", "Companion", "WsEventHandler", "Lavalink-Server"})
@SourceDebugExtension(value={"SMAP\nSocketContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SocketContext.kt\nlavalink/server/io/SocketContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n1869#2,2:242\n1869#2,2:244\n1869#2,2:246\n*S KotlinDebug\n*F\n+ 1 SocketContext.kt\nlavalink/server/io/SocketContext\n*L\n93#1:242,2\n193#1:244,2\n200#1:246,2\n*E\n"})
public final class SocketContext
implements ISocketContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String sessionId;
    @NotNull
    private final AudioPlayerManager audioPlayerManager;
    @NotNull
    private final ServerConfig serverConfig;
    @NotNull
    private WebSocketSession session;
    @NotNull
    private final SocketServer socketServer;
    private final long userId;
    @Nullable
    private final String clientName;
    @NotNull
    private final KoeClient koe;
    @NotNull
    private final List<AudioPluginInfoModifier> pluginInfoModifiers;
    @NotNull
    private final ConcurrentHashMap<Long, LavalinkPlayer> players;
    @NotNull
    private final EventEmitter eventEmitter;
    private volatile boolean sessionPaused;
    @NotNull
    private final ConcurrentLinkedQueue<String> resumeEventQueue;
    private boolean resumable;
    private long resumeTimeout;
    @Nullable
    private ScheduledFuture<Unit> sessionTimeoutFuture;
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private final ScheduledExecutorService playerUpdateService;
    private static final Logger log = LoggerFactory.getLogger(SocketContext.class);

    public SocketContext(@NotNull String sessionId, @NotNull AudioPlayerManager audioPlayerManager, @NotNull ServerConfig serverConfig, @NotNull WebSocketSession session, @NotNull SocketServer socketServer, @NotNull StatsCollector statsCollector, long userId, @Nullable String clientName, @NotNull KoeClient koe, @NotNull Collection<? extends PluginEventHandler> eventHandlers, @NotNull List<? extends AudioPluginInfoModifier> pluginInfoModifiers) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)audioPlayerManager, (String)"audioPlayerManager");
        Intrinsics.checkNotNullParameter((Object)serverConfig, (String)"serverConfig");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)socketServer, (String)"socketServer");
        Intrinsics.checkNotNullParameter((Object)statsCollector, (String)"statsCollector");
        Intrinsics.checkNotNullParameter((Object)koe, (String)"koe");
        Intrinsics.checkNotNullParameter(eventHandlers, (String)"eventHandlers");
        Intrinsics.checkNotNullParameter(pluginInfoModifiers, (String)"pluginInfoModifiers");
        this.sessionId = sessionId;
        this.audioPlayerManager = audioPlayerManager;
        this.serverConfig = serverConfig;
        this.session = session;
        this.socketServer = socketServer;
        this.userId = userId;
        this.clientName = clientName;
        this.koe = koe;
        this.pluginInfoModifiers = pluginInfoModifiers;
        this.players = new ConcurrentHashMap();
        this.eventEmitter = new EventEmitter(this, eventHandlers);
        this.resumeEventQueue = new ConcurrentLinkedQueue();
        this.resumeTimeout = 60L;
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor(...)");
        this.executor = scheduledExecutorService;
        Runnable task = statsCollector.createTask(this);
        this.executor.scheduleAtFixedRate(task, 0L, 1L, TimeUnit.MINUTES);
        ScheduledExecutorService scheduledExecutorService2 = Executors.newScheduledThreadPool(2, SocketContext::_init_$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"newScheduledThreadPool(...)");
        this.playerUpdateService = scheduledExecutorService2;
    }

    @NotNull
    public String getSessionId() {
        return this.sessionId;
    }

    @NotNull
    public final AudioPlayerManager getAudioPlayerManager() {
        return this.audioPlayerManager;
    }

    public long getUserId() {
        return this.userId;
    }

    @Nullable
    public String getClientName() {
        return this.clientName;
    }

    @NotNull
    public final KoeClient getKoe() {
        return this.koe;
    }

    @NotNull
    public ConcurrentHashMap<Long, LavalinkPlayer> getPlayers() {
        return this.players;
    }

    @NotNull
    public final EventEmitter getEventEmitter() {
        return this.eventEmitter;
    }

    public final boolean getSessionPaused() {
        return this.sessionPaused;
    }

    public final void setSessionPaused(boolean bl) {
        this.sessionPaused = bl;
    }

    public final boolean getResumable() {
        return this.resumable;
    }

    public final void setResumable(boolean bl) {
        this.resumable = bl;
    }

    public final long getResumeTimeout() {
        return this.resumeTimeout;
    }

    public final void setResumeTimeout(long l) {
        this.resumeTimeout = l;
    }

    @NotNull
    public final ScheduledExecutorService getPlayerUpdateService() {
        return this.playerUpdateService;
    }

    @NotNull
    public ISocketContext.State getState() {
        return this.session.isOpen() ? ISocketContext.State.OPEN : (this.sessionPaused ? ISocketContext.State.RESUMABLE : ISocketContext.State.DESTROYED);
    }

    @NotNull
    public final List<LavalinkPlayer> getPlayingPlayers() {
        LinkedList<LavalinkPlayer> newList = new LinkedList<LavalinkPlayer>();
        Collection collection = this.getPlayers().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LavalinkPlayer player = (LavalinkPlayer)element$iv;
            boolean bl = false;
            if (!player.isPlaying()) continue;
            newList.add(player);
        }
        return newList;
    }

    @NotNull
    public LavalinkPlayer getPlayer(long guildId) {
        LavalinkPlayer lavalinkPlayer = this.getPlayers().computeIfAbsent(guildId, arg_0 -> SocketContext.getPlayer$lambda$3(arg_0 -> SocketContext.getPlayer$lambda$2(this, guildId, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)lavalinkPlayer, (String)"computeIfAbsent(...)");
        return lavalinkPlayer;
    }

    @NotNull
    public final MediaConnection getMediaConnection(@NotNull LavalinkPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        long guildId = player.getGuildId();
        MediaConnection conn = this.koe.getConnection(guildId);
        if (conn == null) {
            conn = this.koe.createConnection(guildId);
            conn.registerListener((KoeEventListener)new WsEventHandler(this, player));
        }
        return conn;
    }

    public void destroyPlayer(long guildId) {
        LavalinkPlayer player = (LavalinkPlayer)this.getPlayers().remove(guildId);
        if (player != null) {
            this.eventEmitter.onDestroyPlayer((IPlayer)player);
            player.destroy();
        }
        this.koe.destroyConnection(guildId);
    }

    public final void pause() {
        this.sessionPaused = true;
        this.sessionTimeoutFuture = this.executor.schedule(() -> SocketContext.pause$lambda$4(this), this.resumeTimeout, TimeUnit.SECONDS);
        this.eventEmitter.onSocketContextPaused();
    }

    public <T> void sendMessage(@NotNull SerializationStrategy<? super T> serializer2, T message) {
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        this.send(Mapper.getJson().encodeToString(serializer2, message));
    }

    private final void send(String payload) {
        this.eventEmitter.onWebSocketMessageOut(payload);
        if (this.sessionPaused) {
            this.resumeEventQueue.add(payload);
            return;
        }
        if (!this.session.isOpen()) {
            return;
        }
        WebSocketSession webSocketSession = this.session;
        Intrinsics.checkNotNull((Object)webSocketSession, (String)"null cannot be cast to non-null type org.springframework.web.socket.adapter.standard.StandardWebSocketSession");
        Object object = ((StandardWebSocketSession)webSocketSession).getNativeSession();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.undertow.websockets.jsr.UndertowSession");
        UndertowSession undertowSession = (UndertowSession)object;
        WebSockets.sendText((String)payload, (WebSocketChannel)undertowSession.getWebSocketChannel(), (WebSocketCallback)((WebSocketCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    public final boolean stopResumeTimeout() {
        ScheduledFuture scheduledFuture = this.sessionTimeoutFuture;
        return scheduledFuture != null ? scheduledFuture.cancel(false) : false;
    }

    public final void resume(@NotNull WebSocketSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.sessionPaused = false;
        this.session = session;
        this.sendMessage((SerializationStrategy)Message.Serializer, (Object)new Message.ReadyEvent(true, this.getSessionId()));
        log.info("Replaying " + this.resumeEventQueue.size() + " events");
        while (!((Collection)this.resumeEventQueue).isEmpty()) {
            Object e = this.resumeEventQueue.remove();
            Intrinsics.checkNotNullExpressionValue(e, (String)"remove(...)");
            this.send((String)e);
        }
        Collection collection = this.getPlayers().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LavalinkPlayer it = (LavalinkPlayer)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            SocketServer.Companion.sendPlayerUpdate(this, it);
        }
    }

    public final void shutdown$Lavalink_Server() {
        log.info("Shutting down " + this.getPlayingPlayers().size() + " playing players.");
        this.executor.shutdown();
        this.playerUpdateService.shutdown();
        Collection collection = this.getPlayers().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LavalinkPlayer it = (LavalinkPlayer)element$iv;
            boolean bl = false;
            this.destroyPlayer(it.getGuildId());
        }
        this.koe.close();
        this.eventEmitter.onSocketContextDestroyed();
    }

    public void closeWebSocket(int closeCode, @Nullable String reason) {
        this.session.close(new CloseStatus(closeCode, reason));
    }

    public void closeWebSocket(int closeCode) {
        this.closeWebSocket(closeCode, null);
    }

    public void closeWebSocket() {
        this.session.close();
    }

    private static final Thread _init_$lambda$1(Runnable r) {
        Thread thread = new Thread(r);
        thread.setName("player-update");
        thread.setDaemon(true);
        return thread;
    }

    private static final LavalinkPlayer getPlayer$lambda$2(SocketContext this$0, long $guildId, Long it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LavalinkPlayer player = new LavalinkPlayer(this$0, $guildId, this$0.serverConfig, this$0.audioPlayerManager, this$0.pluginInfoModifiers);
        this$0.eventEmitter.onNewPlayer((IPlayer)player);
        return player;
    }

    private static final LavalinkPlayer getPlayer$lambda$3(Function1 $tmp0, Object p0) {
        return (LavalinkPlayer)$tmp0.invoke(p0);
    }

    private static final Unit pause$lambda$4(SocketContext this$0) {
        this$0.socketServer.onSessionResumeTimeout$Lavalink_Server(this$0);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }
}

