/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.player;

import com.sedmelluq.discord.lavaplayer.filter.PcmFilterFactory;
import com.sedmelluq.discord.lavaplayer.format.StandardAudioDataFormats;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventAdapter;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventListener;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import com.sedmelluq.discord.lavaplayer.track.playback.MutableAudioFrame;
import dev.arbjerg.lavalink.api.AudioPluginInfoModifier;
import dev.arbjerg.lavalink.api.IPlayer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import lavalink.server.config.ServerConfig;
import lavalink.server.io.SocketContext;
import lavalink.server.io.SocketServer;
import lavalink.server.player.AudioLossCounter;
import lavalink.server.player.EventEmitter;
import lavalink.server.player.LavalinkPlayer;
import lavalink.server.player.filters.FilterChain;
import moe.kyokobot.koe.MediaConnection;
import moe.kyokobot.koe.media.AudioFrameProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001HB5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u0002062\u0006\u00108\u001a\u000209J\u0010\u0010:\u001a\u0002062\u0006\u00101\u001a\u000202H\u0016J\b\u0010;\u001a\u000206H\u0016J\u0010\u0010<\u001a\u0002062\u0006\u0010=\u001a\u00020\u001eH\u0016J\u0010\u0010>\u001a\u0002062\u0006\u0010?\u001a\u00020\u0006H\u0016J\u0010\u0010@\u001a\u0002062\u0006\u0010A\u001a\u00020BH\u0016J \u0010C\u001a\u0002062\u0006\u0010D\u001a\u00020+2\u0006\u00101\u001a\u0002022\u0006\u0010E\u001a\u00020FH\u0016J\u0018\u0010G\u001a\u0002062\u0006\u0010D\u001a\u00020+2\u0006\u00101\u001a\u000202H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R$\u0010%\u001a\u00020$2\u0006\u0010#\u001a\u00020$@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00100\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010 R\u0016\u00101\u001a\u0004\u0018\u0001028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u0006I"}, d2={"Llavalink/server/player/LavalinkPlayer;", "Lcom/sedmelluq/discord/lavaplayer/player/event/AudioEventAdapter;", "Ldev/arbjerg/lavalink/api/IPlayer;", "socketContext", "Llavalink/server/io/SocketContext;", "guildId", "", "serverConfig", "Llavalink/server/config/ServerConfig;", "audioPlayerManager", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;", "pluginInfoModifiers", "", "Ldev/arbjerg/lavalink/api/AudioPluginInfoModifier;", "<init>", "(Llavalink/server/io/SocketContext;JLlavalink/server/config/ServerConfig;Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayerManager;Ljava/util/List;)V", "getSocketContext", "()Llavalink/server/io/SocketContext;", "getGuildId", "()J", "buffer", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "mutableFrame", "Lcom/sedmelluq/discord/lavaplayer/track/playback/MutableAudioFrame;", "audioLossCounter", "Llavalink/server/player/AudioLossCounter;", "getAudioLossCounter", "()Llavalink/server/player/AudioLossCounter;", "endMarkerHit", "", "getEndMarkerHit", "()Z", "setEndMarkerHit", "(Z)V", "value", "Llavalink/server/player/filters/FilterChain;", "filters", "getFilters", "()Llavalink/server/player/filters/FilterChain;", "setFilters", "(Llavalink/server/player/filters/FilterChain;)V", "audioPlayer", "Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayer;", "getAudioPlayer", "()Lcom/sedmelluq/discord/lavaplayer/player/AudioPlayer;", "updateFuture", "Ljava/util/concurrent/ScheduledFuture;", "isPlaying", "track", "Lcom/sedmelluq/discord/lavaplayer/track/AudioTrack;", "getTrack", "()Lcom/sedmelluq/discord/lavaplayer/track/AudioTrack;", "destroy", "", "provideTo", "connection", "Lmoe/kyokobot/koe/MediaConnection;", "play", "stop", "setPause", "pause", "seekTo", "position", "setVolume", "volume", "", "onTrackEnd", "player", "endReason", "Lcom/sedmelluq/discord/lavaplayer/track/AudioTrackEndReason;", "onTrackStart", "Provider", "Lavalink-Server"})
@SourceDebugExtension(value={"SMAP\nLavalinkPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LavalinkPlayer.kt\nlavalink/server/player/LavalinkPlayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1#2:148\n*E\n"})
public final class LavalinkPlayer
extends AudioEventAdapter
implements IPlayer {
    @NotNull
    private final SocketContext socketContext;
    private final long guildId;
    @NotNull
    private final ServerConfig serverConfig;
    private final ByteBuffer buffer;
    @NotNull
    private final MutableAudioFrame mutableFrame;
    @NotNull
    private final AudioLossCounter audioLossCounter;
    private boolean endMarkerHit;
    @NotNull
    private FilterChain filters;
    @NotNull
    private final AudioPlayer audioPlayer;
    @Nullable
    private ScheduledFuture<?> updateFuture;

    /*
     * WARNING - void declaration
     */
    public LavalinkPlayer(@NotNull SocketContext socketContext, long guildId, @NotNull ServerConfig serverConfig, @NotNull AudioPlayerManager audioPlayerManager, @NotNull List<? extends AudioPluginInfoModifier> pluginInfoModifiers) {
        void it;
        void $this$mutableFrame_u24lambda_u240;
        MutableAudioFrame mutableAudioFrame;
        Intrinsics.checkNotNullParameter((Object)socketContext, (String)"socketContext");
        Intrinsics.checkNotNullParameter((Object)serverConfig, (String)"serverConfig");
        Intrinsics.checkNotNullParameter((Object)audioPlayerManager, (String)"audioPlayerManager");
        Intrinsics.checkNotNullParameter(pluginInfoModifiers, (String)"pluginInfoModifiers");
        this.socketContext = socketContext;
        this.guildId = guildId;
        this.serverConfig = serverConfig;
        this.buffer = ByteBuffer.allocate(StandardAudioDataFormats.DISCORD_OPUS.maximumChunkSize());
        MutableAudioFrame mutableAudioFrame2 = mutableAudioFrame = new MutableAudioFrame();
        LavalinkPlayer lavalinkPlayer = this;
        boolean $i$a$-apply-LavalinkPlayer$mutableFrame$22 = false;
        $this$mutableFrame_u24lambda_u240.setBuffer(this.buffer);
        lavalinkPlayer.mutableFrame = mutableAudioFrame;
        this.audioLossCounter = new AudioLossCounter();
        this.filters = new FilterChain(null, null, null, null, null, null, null, null, null, null, 1023, null);
        MutableAudioFrame $i$a$-apply-LavalinkPlayer$mutableFrame$22 = mutableAudioFrame2 = audioPlayerManager.createPlayer();
        lavalinkPlayer = this;
        boolean bl = false;
        it.addListener((AudioEventListener)this);
        it.addListener((AudioEventListener)new EventEmitter(audioPlayerManager, this, pluginInfoModifiers));
        it.addListener((AudioEventListener)this.audioLossCounter);
        MutableAudioFrame mutableAudioFrame3 = mutableAudioFrame2;
        Intrinsics.checkNotNullExpressionValue((Object)mutableAudioFrame3, (String)"also(...)");
        lavalinkPlayer.audioPlayer = mutableAudioFrame3;
    }

    @NotNull
    public SocketContext getSocketContext() {
        return this.socketContext;
    }

    public long getGuildId() {
        return this.guildId;
    }

    @NotNull
    public final AudioLossCounter getAudioLossCounter() {
        return this.audioLossCounter;
    }

    public final boolean getEndMarkerHit() {
        return this.endMarkerHit;
    }

    public final void setEndMarkerHit(boolean bl) {
        this.endMarkerHit = bl;
    }

    @NotNull
    public final FilterChain getFilters() {
        return this.filters;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFilters(@NotNull FilterChain value) {
        void it;
        FilterChain filterChain;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        FilterChain filterChain2 = filterChain = value;
        AudioPlayer audioPlayer = this.getAudioPlayer();
        boolean bl = false;
        boolean bl2 = it.isEnabled();
        audioPlayer.setFilterFactory((PcmFilterFactory)(bl2 ? filterChain : null));
        this.filters = value;
    }

    @NotNull
    public AudioPlayer getAudioPlayer() {
        return this.audioPlayer;
    }

    public boolean isPlaying() {
        return this.getAudioPlayer().getPlayingTrack() != null && !this.getAudioPlayer().isPaused();
    }

    @Nullable
    public AudioTrack getTrack() {
        return this.getAudioPlayer().getPlayingTrack();
    }

    public final void destroy() {
        this.getAudioPlayer().destroy();
    }

    public final void provideTo(@NotNull MediaConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        connection.setAudioSender((AudioFrameProvider)new Provider(this));
    }

    public void play(@NotNull AudioTrack track) {
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        this.getAudioPlayer().playTrack(track);
        SocketServer.Companion.sendPlayerUpdate(this.getSocketContext(), this);
    }

    public void stop() {
        this.getAudioPlayer().stopTrack();
    }

    public void setPause(boolean pause) {
        this.getAudioPlayer().setPaused(pause);
    }

    public void seekTo(long position) {
        AudioTrack audioTrack = this.getAudioPlayer().getPlayingTrack();
        if (audioTrack == null) {
            throw new RuntimeException("Can't seek when not playing anything");
        }
        AudioTrack track = audioTrack;
        track.setPosition(position);
    }

    public void setVolume(int volume) {
        this.getAudioPlayer().setVolume(volume);
    }

    public void onTrackEnd(@NotNull AudioPlayer player, @NotNull AudioTrack track, @NotNull AudioTrackEndReason endReason) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)track, (String)"track");
            Intrinsics.checkNotNullParameter((Object)endReason, (String)"endReason");
            ScheduledFuture scheduledFuture = this.updateFuture;
            if (scheduledFuture == null) break block0;
            scheduledFuture.cancel(false);
        }
    }

    public void onTrackStart(@NotNull AudioPlayer player, @NotNull AudioTrack track) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        ScheduledFuture scheduledFuture = this.updateFuture;
        boolean bl = scheduledFuture != null ? !scheduledFuture.isCancelled() : false;
        if (bl) {
            return;
        }
        this.updateFuture = this.getSocketContext().getPlayerUpdateService().scheduleAtFixedRate(() -> LavalinkPlayer.onTrackStart$lambda$3(this), 0L, this.serverConfig.getPlayerUpdateInterval(), TimeUnit.SECONDS);
    }

    private static final void onTrackStart$lambda$3(LavalinkPlayer this$0) {
        SocketServer.Companion.sendPlayerUpdate(this$0.getSocketContext(), this$0);
    }

    public static final /* synthetic */ MutableAudioFrame access$getMutableFrame$p(LavalinkPlayer $this) {
        return $this.mutableFrame;
    }

    public static final /* synthetic */ ByteBuffer access$getBuffer$p(LavalinkPlayer $this) {
        return $this.buffer;
    }
}

