/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.player;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.TrackMarker;
import com.sedmelluq.discord.lavaplayer.track.TrackMarkerHandler;
import dev.arbjerg.lavalink.api.AudioFilterExtension;
import dev.arbjerg.lavalink.api.AudioPluginInfoModifier;
import dev.arbjerg.lavalink.protocol.v4.Filters;
import dev.arbjerg.lavalink.protocol.v4.Omissible;
import dev.arbjerg.lavalink.protocol.v4.OmissibleKt;
import dev.arbjerg.lavalink.protocol.v4.Player;
import dev.arbjerg.lavalink.protocol.v4.PlayerUpdate;
import dev.arbjerg.lavalink.protocol.v4.PlayerUpdateTrack;
import dev.arbjerg.lavalink.protocol.v4.Players;
import dev.arbjerg.lavalink.protocol.v4.VoiceState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonObject;
import lavalink.server.config.ServerConfig;
import lavalink.server.io.SocketContext;
import lavalink.server.io.SocketServer;
import lavalink.server.player.LavalinkPlayer;
import lavalink.server.player.PlayerRestHandler;
import lavalink.server.player.TrackEndMarkerHandler;
import lavalink.server.player.filters.FilterChain;
import lavalink.server.util.LoadingKt;
import lavalink.server.util.UtilKt;
import moe.kyokobot.koe.MediaConnection;
import moe.kyokobot.koe.VoiceServerInfo;
import moe.kyokobot.koe.gateway.MediaGatewayConnection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000  2\u00020\u0001:\u0001 B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0001\u0010\u0014\u001a\u00020\u000eH\u0013J\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\b\b\u0001\u0010\u0014\u001a\u00020\u000e2\b\b\u0001\u0010\u0017\u001a\u00020\u0018H\u0013J6\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u0014\u001a\u00020\u000e2\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0003\u0010\u001c\u001a\u00020\u001dH\u0013J\u001c\u0010\u001e\u001a\u00020\u001f2\b\b\u0001\u0010\u0014\u001a\u00020\u000e2\b\b\u0001\u0010\u0017\u001a\u00020\u0018H\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Llavalink/server/player/PlayerRestHandler;", "", "socketServer", "Llavalink/server/io/SocketServer;", "filterExtensions", "", "Ldev/arbjerg/lavalink/api/AudioFilterExtension;", "pluginInfoModifiers", "Ldev/arbjerg/lavalink/api/AudioPluginInfoModifier;", "serverConfig", "Llavalink/server/config/ServerConfig;", "<init>", "(Llavalink/server/io/SocketServer;Ljava/util/List;Ljava/util/List;Llavalink/server/config/ServerConfig;)V", "disabledFilters", "", "getDisabledFilters", "()Ljava/util/List;", "getPlayers", "Lorg/springframework/http/ResponseEntity;", "Ldev/arbjerg/lavalink/protocol/v4/Players;", "sessionId", "getPlayer", "Ldev/arbjerg/lavalink/protocol/v4/Player;", "guildId", "", "patchPlayer", "playerUpdate", "Ldev/arbjerg/lavalink/protocol/v4/PlayerUpdate;", "noReplace", "", "deletePlayer", "", "Companion", "Lavalink-Server"})
@SourceDebugExtension(value={"SMAP\nPlayerRestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerRestHandler.kt\nlavalink/server/player/PlayerRestHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 omissible.kt\ndev/arbjerg/lavalink/protocol/v4/OmissibleKt\n*L\n1#1,239:1\n774#2:240\n865#2,2:241\n1563#2:243\n1634#2,3:244\n1563#2:247\n1634#2,3:248\n38#3:251\n38#3:252\n38#3:253\n38#3:254\n38#3:255\n38#3:256\n38#3:257\n38#3:258\n38#3:259\n38#3:260\n38#3:261\n38#3:262\n*S KotlinDebug\n*F\n+ 1 PlayerRestHandler.kt\nlavalink/server/player/PlayerRestHandler\n*L\n32#1:240\n32#1:241,2\n32#1:243\n32#1:244,3\n38#1:247\n38#1:248,3\n79#1:251\n80#1:252\n81#1:253\n87#1:254\n98#1:255\n105#1:256\n113#1:257\n156#1:258\n175#1:259\n209#1:260\n213#1:261\n217#1:262\n*E\n"})
public class PlayerRestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SocketServer socketServer;
    @NotNull
    private final List<AudioFilterExtension> filterExtensions;
    @NotNull
    private final List<AudioPluginInfoModifier> pluginInfoModifiers;
    @NotNull
    private final List<String> disabledFilters;
    private static final Logger log = LoggerFactory.getLogger(PlayerRestHandler.class);

    /*
     * WARNING - void declaration
     */
    public PlayerRestHandler(@NotNull SocketServer socketServer, @NotNull List<? extends AudioFilterExtension> filterExtensions, @NotNull List<? extends AudioPluginInfoModifier> pluginInfoModifiers, @NotNull ServerConfig serverConfig) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)socketServer, (String)"socketServer");
        Intrinsics.checkNotNullParameter(filterExtensions, (String)"filterExtensions");
        Intrinsics.checkNotNullParameter(pluginInfoModifiers, (String)"pluginInfoModifiers");
        Intrinsics.checkNotNullParameter((Object)serverConfig, (String)"serverConfig");
        this.socketServer = socketServer;
        this.filterExtensions = filterExtensions;
        this.pluginInfoModifiers = pluginInfoModifiers;
        Iterable iterable = serverConfig.getFilters().entrySet();
        PlayerRestHandler playerRestHandler = this;
        boolean $i$f$filter = false;
        void var7_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)it.getValue() == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getKey());
        }
        playerRestHandler.disabledFilters = (List)destination$iv$iv;
    }

    @NotNull
    public List<String> getDisabledFilters() {
        return this.disabledFilters;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/v4/sessions/{sessionId}/players"})
    private ResponseEntity<Players> getPlayers(@PathVariable String sessionId) {
        void $this$mapTo$iv$iv;
        SocketContext context = UtilKt.socketContext((SocketServer)this.socketServer, (String)sessionId);
        Collection collection = context.getPlayers().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LavalinkPlayer lavalinkPlayer = (LavalinkPlayer)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection2.add(UtilKt.toPlayer((LavalinkPlayer)it, (SocketContext)context, (List)this.pluginInfoModifiers));
        }
        ResponseEntity responseEntity = ResponseEntity.ok((Object)Players.box-impl((List)Players.constructor-impl((List)((List)destination$iv$iv))));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @GetMapping(value={"/v4/sessions/{sessionId}/players/{guildId}"})
    private ResponseEntity<Player> getPlayer(@PathVariable String sessionId, @PathVariable long guildId) {
        SocketContext context = UtilKt.socketContext((SocketServer)this.socketServer, (String)sessionId);
        LavalinkPlayer player = UtilKt.existingPlayer((SocketContext)context, (long)guildId);
        ResponseEntity responseEntity = ResponseEntity.ok((Object)UtilKt.toPlayer((LavalinkPlayer)player, (SocketContext)context, (List)this.pluginInfoModifiers));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PatchMapping(value={"/v4/sessions/{sessionId}/players/{guildId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    private ResponseEntity<Player> patchPlayer(@RequestBody PlayerUpdate playerUpdate, @PathVariable String sessionId, @PathVariable long guildId, @RequestParam boolean noReplace) {
        Omissible paused;
        Boolean $i$f$ifPresent;
        LavalinkPlayer player;
        Omissible userData;
        Omissible identifier;
        Omissible encodedTrack;
        SocketContext context;
        block49: {
            Omissible omissible;
            Omissible omissible2;
            Omissible omissible3;
            Omissible omissible4;
            Omissible omissible5;
            Omissible omissible6;
            Omissible track;
            context = UtilKt.socketContext((SocketServer)this.socketServer, (String)sessionId);
            if (OmissibleKt.isPresent((Omissible)playerUpdate.getTrack()) && (playerUpdate.getEncodedTrack() instanceof Omissible.Present || playerUpdate.getIdentifier() instanceof Omissible.Present)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Cannot specify both track and encodedTrack/identifier");
            }
            Omissible $this$ifPresent$iv = track = OmissibleKt.isPresent((Omissible)playerUpdate.getTrack()) ? playerUpdate.getTrack() : (playerUpdate.getEncodedTrack() instanceof Omissible.Present || playerUpdate.getIdentifier() instanceof Omissible.Present ? OmissibleKt.toOmissible((Object)new PlayerUpdateTrack(playerUpdate.getEncodedTrack(), playerUpdate.getIdentifier(), null, 4, null)) : (Omissible)Omissible.Omitted.Companion.invoke());
            boolean $i$f$ifPresent2 = false;
            if ($this$ifPresent$iv instanceof Omissible.Present) {
                PlayerUpdateTrack it = (PlayerUpdateTrack)((Omissible.Present)$this$ifPresent$iv).unbox-impl();
                boolean bl = false;
                omissible6 = it.getEncoded();
            } else {
                omissible6 = omissible5 = null;
            }
            if (omissible6 == null) {
                omissible5 = (Omissible)Omissible.Omitted.Companion.invoke();
            }
            encodedTrack = omissible5;
            Omissible $this$ifPresent$iv2 = track;
            boolean $i$f$ifPresent3 = false;
            if ($this$ifPresent$iv2 instanceof Omissible.Present) {
                PlayerUpdateTrack it = (PlayerUpdateTrack)((Omissible.Present)$this$ifPresent$iv2).unbox-impl();
                boolean bl = false;
                omissible4 = it.getIdentifier();
            } else {
                omissible4 = omissible3 = null;
            }
            if (omissible4 == null) {
                omissible3 = (Omissible)Omissible.Omitted.Companion.invoke();
            }
            identifier = omissible3;
            Omissible $this$ifPresent$iv3 = track;
            boolean $i$f$ifPresent4 = false;
            if ($this$ifPresent$iv3 instanceof Omissible.Present) {
                PlayerUpdateTrack it = (PlayerUpdateTrack)((Omissible.Present)$this$ifPresent$iv3).unbox-impl();
                boolean bl = false;
                omissible2 = it.getUserData();
            } else {
                omissible2 = omissible = null;
            }
            if (omissible2 == null) {
                omissible = userData = (Omissible)Omissible.Omitted.Companion.invoke();
            }
            if (encodedTrack instanceof Omissible.Present && identifier instanceof Omissible.Present) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Cannot specify both encodedTrack and identifier");
            }
            $this$ifPresent$iv2 = playerUpdate.getFilters();
            $i$f$ifPresent = false;
            if ($this$ifPresent$iv2 instanceof Omissible.Present) {
                Filters filters = (Filters)((Omissible.Present)$this$ifPresent$iv2).unbox-impl();
                boolean bl = false;
                List invalidFilters = filters.validate(this.getDisabledFilters());
                if (!((Collection)invalidFilters).isEmpty()) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Following filters are disabled in the config: " + CollectionsKt.joinToString$default((Iterable)invalidFilters, null, null, null, (int)0, null, null, (int)63, null));
                }
            }
            $this$ifPresent$iv2 = playerUpdate.getVoice();
            $i$f$ifPresent = false;
            if ($this$ifPresent$iv2 instanceof Omissible.Present) {
                VoiceState it = (VoiceState)((Omissible.Present)$this$ifPresent$iv2).unbox-impl();
                boolean bl = false;
                if (((CharSequence)it.getEndpoint()).length() == 0 || ((CharSequence)it.getToken()).length() == 0 || ((CharSequence)it.getSessionId()).length() == 0) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Partial Lavalink voice state: " + it);
                }
            }
            $this$ifPresent$iv2 = playerUpdate.getEndTime();
            $i$f$ifPresent = false;
            if ($this$ifPresent$iv2 instanceof Omissible.Present) {
                Long it = (Long)((Omissible.Present)$this$ifPresent$iv2).unbox-impl();
                boolean bl = false;
                if (it != null && it <= 0L) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "End time must be greater than 0");
                }
            }
            player = context.getPlayer(guildId);
            $this$ifPresent$iv = playerUpdate.getVoice();
            $i$f$ifPresent = false;
            if (!($this$ifPresent$iv instanceof Omissible.Present)) break block49;
            VoiceState it = (VoiceState)((Omissible.Present)$this$ifPresent$iv).unbox-impl();
            boolean bl = false;
            LavalinkPlayer lavalinkPlayer = player;
            synchronized (lavalinkPlayer) {
                block51: {
                    block50: {
                        boolean bl2 = false;
                        MediaConnection oldConn = context.getKoe().getConnection(guildId);
                        if (oldConn == null) break block50;
                        MediaGatewayConnection mediaGatewayConnection = oldConn.getGatewayConnection();
                        if ((mediaGatewayConnection != null ? !mediaGatewayConnection.isOpen() : false) || oldConn.getVoiceServerInfo() == null) break block50;
                        VoiceServerInfo voiceServerInfo = oldConn.getVoiceServerInfo();
                        if (!Intrinsics.areEqual((Object)(voiceServerInfo != null ? voiceServerInfo.getEndpoint() : null), (Object)it.getEndpoint())) break block50;
                        VoiceServerInfo voiceServerInfo2 = oldConn.getVoiceServerInfo();
                        if (!Intrinsics.areEqual((Object)(voiceServerInfo2 != null ? voiceServerInfo2.getToken() : null), (Object)it.getToken())) break block50;
                        VoiceServerInfo voiceServerInfo3 = oldConn.getVoiceServerInfo();
                        if (!Intrinsics.areEqual((Object)(voiceServerInfo3 != null ? voiceServerInfo3.getSessionId() : null), (Object)it.getSessionId())) break block50;
                        VoiceServerInfo voiceServerInfo4 = oldConn.getVoiceServerInfo();
                        if (voiceServerInfo4 != null ? voiceServerInfo4.getChannelId() == Long.parseLong(it.getChannelId()) : false) break block51;
                    }
                    context.getKoe().destroyConnection(guildId);
                    MediaConnection conn = context.getMediaConnection(player);
                    conn.connect(VoiceServerInfo.builder().setSessionId(it.getSessionId()).setEndpoint(it.getSessionId()).setToken(it.getSessionId()).setChannelId(Long.parseLong(it.getChannelId())).build()).exceptionally(PlayerRestHandler::patchPlayer$lambda$11$lambda$10$lambda$9).toCompletableFuture().join();
                    player.provideTo(conn);
                }
                Unit bl2 = Unit.INSTANCE;
            }
        }
        if (($i$f$ifPresent = (Boolean)OmissibleKt.takeIfPresent((Omissible)(paused = playerUpdate.getPaused()), arg_0 -> PlayerRestHandler.patchPlayer$lambda$12(encodedTrack, identifier, arg_0))) != null) {
            boolean it = $i$f$ifPresent;
            boolean bl = false;
            player.setPause(it);
        }
        $i$f$ifPresent = (JsonObject)OmissibleKt.takeIfPresent((Omissible)userData, arg_0 -> PlayerRestHandler.patchPlayer$lambda$14(encodedTrack, identifier, arg_0));
        if ($i$f$ifPresent != null) {
            Boolean it = $i$f$ifPresent;
            boolean bl = false;
            AudioTrack audioTrack = player.getTrack();
            if (audioTrack != null) {
                audioTrack.setUserData((Object)it);
            }
        }
        Object $this$ifPresent$iv = playerUpdate.getVolume();
        boolean $i$f$ifPresent5 = false;
        if ($this$ifPresent$iv instanceof Omissible.Present) {
            int it = ((Number)((Omissible.Present)$this$ifPresent$iv).unbox-impl()).intValue();
            boolean bl = false;
            player.setVolume(it);
        }
        if (($this$ifPresent$iv = (Long)OmissibleKt.takeIfPresent((Omissible)playerUpdate.getPosition(), arg_0 -> PlayerRestHandler.patchPlayer$lambda$17(encodedTrack, identifier, arg_0))) != null) {
            long it = ((Number)$this$ifPresent$iv).longValue();
            boolean bl = false;
            if (player.getTrack() != null) {
                player.seekTo(it);
                SocketServer.Companion.sendPlayerUpdate(context, player);
            }
        }
        $this$ifPresent$iv = (Long)OmissibleKt.takeIfPresent((Omissible)playerUpdate.getEndTime(), arg_0 -> PlayerRestHandler.patchPlayer$lambda$19(encodedTrack, identifier, arg_0));
        if ($this$ifPresent$iv != null) {
            long endTime = ((Number)$this$ifPresent$iv).longValue();
            boolean bl = false;
            TrackMarker marker = new TrackMarker(endTime, (TrackMarkerHandler)new TrackEndMarkerHandler(player));
            AudioTrack audioTrack = player.getTrack();
            if (audioTrack != null) {
                audioTrack.setMarker(marker);
            }
        }
        $this$ifPresent$iv = playerUpdate.getFilters();
        $i$f$ifPresent5 = false;
        if ($this$ifPresent$iv instanceof Omissible.Present) {
            Filters it = (Filters)((Omissible.Present)$this$ifPresent$iv).unbox-impl();
            boolean bl = false;
            player.setFilters(FilterChain.Companion.parse(it, this.filterExtensions));
            SocketServer.Companion.sendPlayerUpdate(context, player);
        }
        if (encodedTrack instanceof Omissible.Present || identifier instanceof Omissible.Present) {
            AudioTrack newTrack;
            AudioTrack audioTrack;
            if (noReplace && player.getTrack() != null) {
                log.info("Skipping play request because of noReplace");
                ResponseEntity responseEntity = ResponseEntity.ok((Object)UtilKt.toPlayer((LavalinkPlayer)player, (SocketContext)context, (List)this.pluginInfoModifiers));
                Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
                return responseEntity;
            }
            player.setPause(paused instanceof Omissible.Present ? (Boolean)((Omissible.Present)paused).unbox-impl() : false);
            if (encodedTrack instanceof Omissible.Present) {
                String string = (String)((Omissible.Present)encodedTrack).unbox-impl();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    audioTrack = UtilKt.decodeTrack((AudioPlayerManager)context.getAudioPlayerManager(), (String)it);
                } else {
                    audioTrack = null;
                }
            } else {
                AudioItem audioItem;
                try {
                    AudioPlayerManager audioPlayerManager = context.getAudioPlayerManager();
                    Intrinsics.checkNotNull((Object)identifier, (String)"null cannot be cast to non-null type dev.arbjerg.lavalink.protocol.v4.Omissible.Present<kotlin.String>");
                    audioItem = LoadingKt.loadAudioItem((AudioPlayerManager)audioPlayerManager, (String)((String)((Omissible.Present)identifier).unbox-impl()));
                }
                catch (FriendlyException ex) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ex.getMessage(), UtilKt.getRootCause((Throwable)ex));
                }
                AudioItem item = audioItem;
                if (!(item instanceof AudioTrack)) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, item == null ? "No matches found for identifier" : "Cannot play a playlist or search result");
                }
                audioTrack = (AudioTrack)item;
            }
            AudioTrack audioTrack2 = newTrack = audioTrack;
            if (audioTrack2 != null) {
                AudioTrack it = audioTrack2;
                boolean bl = false;
                Omissible $this$ifPresent$iv4 = playerUpdate.getPosition();
                boolean $i$f$ifPresent6 = false;
                if ($this$ifPresent$iv4 instanceof Omissible.Present) {
                    long position = ((Number)((Omissible.Present)$this$ifPresent$iv4).unbox-impl()).longValue();
                    boolean bl3 = false;
                    newTrack.setPosition(position);
                }
                $this$ifPresent$iv4 = userData;
                $i$f$ifPresent6 = false;
                if ($this$ifPresent$iv4 instanceof Omissible.Present) {
                    JsonObject userData2 = (JsonObject)((Omissible.Present)$this$ifPresent$iv4).unbox-impl();
                    boolean bl4 = false;
                    newTrack.setUserData((Object)userData2);
                }
                $this$ifPresent$iv4 = playerUpdate.getEndTime();
                $i$f$ifPresent6 = false;
                if ($this$ifPresent$iv4 instanceof Omissible.Present) {
                    Long endTime = (Long)((Omissible.Present)$this$ifPresent$iv4).unbox-impl();
                    boolean bl5 = false;
                    if (endTime != null) {
                        newTrack.setMarker(new TrackMarker(endTime.longValue(), (TrackMarkerHandler)new TrackEndMarkerHandler(player)));
                    }
                }
                player.play(newTrack);
                player.provideTo(context.getMediaConnection(player));
            } else {
                player.stop();
            }
        }
        ResponseEntity responseEntity = ResponseEntity.ok((Object)UtilKt.toPlayer((LavalinkPlayer)player, (SocketContext)context, (List)this.pluginInfoModifiers));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    static /* synthetic */ ResponseEntity patchPlayer$default(PlayerRestHandler playerRestHandler, PlayerUpdate playerUpdate, String string, long l, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: patchPlayer");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return playerRestHandler.patchPlayer(playerUpdate, string, l, bl);
    }

    @DeleteMapping(value={"/v4/sessions/{sessionId}/players/{guildId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    private void deletePlayer(@PathVariable String sessionId, @PathVariable long guildId) {
        UtilKt.socketContext((SocketServer)this.socketServer, (String)sessionId).destroyPlayer(guildId);
    }

    private static final Void patchPlayer$lambda$11$lambda$10$lambda$9(Throwable it) {
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Failed to connect to voice server");
    }

    private static final boolean patchPlayer$lambda$12(Omissible $encodedTrack, Omissible $identifier, boolean it) {
        return $encodedTrack instanceof Omissible.Omitted && $identifier instanceof Omissible.Omitted;
    }

    private static final boolean patchPlayer$lambda$14(Omissible $encodedTrack, Omissible $identifier, JsonObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $encodedTrack instanceof Omissible.Omitted && $identifier instanceof Omissible.Omitted;
    }

    private static final boolean patchPlayer$lambda$17(Omissible $encodedTrack, Omissible $identifier, long it) {
        return $encodedTrack instanceof Omissible.Omitted && $identifier instanceof Omissible.Omitted;
    }

    private static final boolean patchPlayer$lambda$19(Omissible $encodedTrack, Omissible $identifier, Long it) {
        return $encodedTrack instanceof Omissible.Omitted && $identifier instanceof Omissible.Omitted;
    }
}

