/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server;

import com.sedmelluq.discord.lavaplayer.tools.PlayerLibrary;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import lavalink.server.LavalinkApplication;
import lavalink.server.bootstrap.PluginManager;
import lavalink.server.bootstrap.PluginManifest;
import lavalink.server.info.AppInfo;
import lavalink.server.info.GitRepoState;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

/*
 * Exception performing whole class analysis ignored.
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0002J\u001b\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H\u0007\u00a2\u0006\u0002\u0010\u0015J#\u0010\u0016\u001a\n \u0006*\u0004\u0018\u00010\u00170\u00172\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H\u0002\u00a2\u0006\u0002\u0010\u0018J#\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00172\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H\u0002\u00a2\u0006\u0002\u0010\u001bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Llavalink/server/Launcher;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "startTime", "", "getStartTime", "()J", "getVersionInfo", "", "indentation", "vanity", "", "getVanity", "main", "", "args", "", "([Ljava/lang/String;)V", "launchPluginBootstrap", "Lorg/springframework/context/ConfigurableApplicationContext;", "([Ljava/lang/String;)Lorg/springframework/context/ConfigurableApplicationContext;", "launchMain", "parent", "(Lorg/springframework/context/ConfigurableApplicationContext;[Ljava/lang/String;)V", "Lavalink-Server"})
@SourceDebugExtension(value={"SMAP\nLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Launcher.kt\nlavalink/server/Launcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1#2:168\n1563#3:169\n1634#3,3:170\n*S KotlinDebug\n*F\n+ 1 Launcher.kt\nlavalink/server/Launcher\n*L\n138#1:169\n138#1:170,3\n*E\n"})
public final class Launcher {
    @NotNull
    public static final Launcher INSTANCE = new Launcher();
    private static final Logger log = LoggerFactory.getLogger(Launcher.class);
    private static final long startTime = System.currentTimeMillis();

    private Launcher() {
    }

    public final long getStartTime() {
        return startTime;
    }

    private final String getVersionInfo(String indentation, boolean vanity) {
        StringBuilder stringBuilder;
        String string;
        AppInfo appInfo = new AppInfo();
        GitRepoState gitRepoState = new GitRepoState();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss z").withZone(ZoneId.of("UTC"));
        String buildTime = dtf.format(Instant.ofEpochMilli(appInfo.getBuildTime()));
        String commitTime = dtf.format(Instant.ofEpochMilli(gitRepoState.getCommitTime() * (long)1000));
        String it = string = appInfo.getVersionBuild();
        boolean bl = false;
        String string2 = !StringsKt.startsWith$default((String)it, (String)"@", (boolean)false, (int)2, null) ? string : null;
        if (string2 == null) {
            string2 = "Unknown";
        }
        String version = string2;
        StringBuilder $this$getVersionInfo_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl2 = false;
        if (vanity) {
            $this$getVersionInfo_u24lambda_u241.append('\n');
            $this$getVersionInfo_u24lambda_u241.append('\n');
            $this$getVersionInfo_u24lambda_u241.append(INSTANCE.getVanity()).append('\n');
        }
        if (!gitRepoState.isLoaded()) {
            $this$getVersionInfo_u24lambda_u241.append('\n');
            $this$getVersionInfo_u24lambda_u241.append(indentation + "*** Unable to find or load Git metadata ***").append('\n');
        }
        $this$getVersionInfo_u24lambda_u241.append('\n');
        $this$getVersionInfo_u24lambda_u241.append(indentation + "Version:        ");
        $this$getVersionInfo_u24lambda_u241.append(version).append('\n');
        if (gitRepoState.isLoaded()) {
            $this$getVersionInfo_u24lambda_u241.append(indentation + "Build time:     ");
            $this$getVersionInfo_u24lambda_u241.append(buildTime).append('\n');
            $this$getVersionInfo_u24lambda_u241.append(indentation + "Branch          ");
            $this$getVersionInfo_u24lambda_u241.append(gitRepoState.getBranch()).append('\n');
            $this$getVersionInfo_u24lambda_u241.append(indentation + "Commit:         ");
            $this$getVersionInfo_u24lambda_u241.append(gitRepoState.getCommitIdAbbrev()).append('\n');
            $this$getVersionInfo_u24lambda_u241.append(indentation + "Commit time:    ");
            $this$getVersionInfo_u24lambda_u241.append(commitTime).append('\n');
        }
        $this$getVersionInfo_u24lambda_u241.append(indentation + "JVM:            ");
        $this$getVersionInfo_u24lambda_u241.append(System.getProperty("java.version")).append('\n');
        $this$getVersionInfo_u24lambda_u241.append(indentation + "Lavaplayer      ");
        $this$getVersionInfo_u24lambda_u241.append(PlayerLibrary.VERSION).append('\n');
        return stringBuilder.toString();
    }

    static /* synthetic */ String getVersionInfo$default(Launcher launcher, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = "\t";
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return launcher.getVersionInfo(string, bl);
    }

    private final String getVanity() {
        String red = "\u001b[31m";
        String green = "\u001b[32m";
        String defaultC = "\u001b[0m";
        String vanity = "g       .  r _                  _ _       _    g__ _ _\ng      /\\\\ r| | __ ___   ____ _| (_)_ __ | | __g\\ \\ \\ \\\ng     ( ( )r| |/ _` \\ \\ / / _` | | | '_ \\| |/ /g \\ \\ \\ \\\ng      \\\\/ r| | (_| |\\ V / (_| | | | | | |   < g  ) ) ) )\ng       '  r|_|\\__,_| \\_/ \\__,_|_|_|_| |_|_|\\_\\g / / / /\nd    =========================================g/_/_/_/d";
        CharSequence charSequence = vanity;
        vanity = new Regex("r").replace(charSequence, red);
        charSequence = vanity;
        vanity = new Regex("g").replace(charSequence, green);
        charSequence = vanity;
        vanity = new Regex("d").replace(charSequence, defaultC);
        return vanity;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (!(args.length == 0) && (StringsKt.equals((String)args[0], (String)"-v", (boolean)true) || StringsKt.equals((String)args[0], (String)"--version", (boolean)true))) {
            System.out.println((Object)INSTANCE.getVersionInfo("", false));
            return;
        }
        ConfigurableApplicationContext parent = INSTANCE.launchPluginBootstrap(args);
        Intrinsics.checkNotNull((Object)parent);
        INSTANCE.launchMain(parent, args);
    }

    private final ConfigurableApplicationContext launchPluginBootstrap(String[] args) {
        Class[] classArray = new Class[]{PluginManager.class};
        SpringApplication $this$launchPluginBootstrap_u24lambda_u242 = new SpringApplication(classArray);
        boolean bl = false;
        $this$launchPluginBootstrap_u24lambda_u242.setBannerMode(Banner.Mode.OFF);
        $this$launchPluginBootstrap_u24lambda_u242.setWebApplicationType(WebApplicationType.NONE);
        return $this$launchPluginBootstrap_u24lambda_u242.run(Arrays.copyOf(args, args.length));
    }

    /*
     * WARNING - void declaration
     */
    private final void launchMain(ConfigurableApplicationContext parent, String[] args) {
        List list;
        void $this$mapTo$iv$iv;
        PluginManager pluginManager = (PluginManager)parent.getBean(PluginManager.class);
        Properties properties = new Properties();
        Class[] classArray = (Class[])properties;
        String string = "componentScan";
        Iterable $this$map$iv = pluginManager.getPluginManifests();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PluginManifest pluginManifest = (PluginManifest)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        List $this$launchMain_u24lambda_u244 = list = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        boolean bl = false;
        $this$launchMain_u24lambda_u244.add("lavalink.server");
        classArray.put(string, list);
        classArray = new Class[]{LavalinkApplication.class};
        SpringApplicationBuilder springApplicationBuilder = new SpringApplicationBuilder(new Class[0]).sources(classArray).properties(properties).web(WebApplicationType.SERVLET).bannerMode(Banner.Mode.OFF).resourceLoader((ResourceLoader)new DefaultResourceLoader(pluginManager.getClassLoader()));
        classArray = new ApplicationListener[]{Launcher::launchMain$lambda$5};
        springApplicationBuilder.listeners((ApplicationListener[])classArray).parent(parent).run(Arrays.copyOf(args, args.length));
    }

    private static final void launchMain$lambda$5(Object event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event;
        if (object instanceof ApplicationEnvironmentPreparedEvent) {
            log.info(Launcher.getVersionInfo$default((Launcher)INSTANCE, null, (boolean)false, (int)3, null));
        } else if (object instanceof ApplicationReadyEvent) {
            log.info("Lavalink is ready to accept connections.");
        } else if (object instanceof ApplicationFailedEvent) {
            log.error("Application failed", ((ApplicationFailedEvent)event).getException());
        }
    }
}

