/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.config;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import lavalink.server.config.WebsocketConfig;
import lavalink.server.io.HandshakeInterceptorImpl;
import lavalink.server.io.SocketServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistration;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.server.HandshakeInterceptor;

@Configuration
@EnableWebSocket
@RestController
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Llavalink/server/config/WebsocketConfig;", "Lorg/springframework/web/socket/config/annotation/WebSocketConfigurer;", "server", "Llavalink/server/io/SocketServer;", "handshakeInterceptor", "Llavalink/server/io/HandshakeInterceptorImpl;", "<init>", "(Llavalink/server/io/SocketServer;Llavalink/server/io/HandshakeInterceptorImpl;)V", "registerWebSocketHandlers", "", "registry", "Lorg/springframework/web/socket/config/annotation/WebSocketHandlerRegistry;", "oldWebsocket", "Companion", "Lavalink-Server"})
public class WebsocketConfig
implements WebSocketConfigurer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SocketServer server;
    @NotNull
    private final HandshakeInterceptorImpl handshakeInterceptor;
    private static final Logger log = LoggerFactory.getLogger(WebsocketConfig.class);

    public WebsocketConfig(@NotNull SocketServer server, @NotNull HandshakeInterceptorImpl handshakeInterceptor) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)handshakeInterceptor, (String)"handshakeInterceptor");
        this.server = server;
        this.handshakeInterceptor = handshakeInterceptor;
    }

    public void registerWebSocketHandlers(@NotNull WebSocketHandlerRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        String[] stringArray = new String[]{"/v4/websocket"};
        WebSocketHandlerRegistration webSocketHandlerRegistration = registry.addHandler((WebSocketHandler)this.server, stringArray);
        stringArray = new HandshakeInterceptor[]{this.handshakeInterceptor};
        webSocketHandlerRegistration.addInterceptors((HandshakeInterceptor[])stringArray);
    }

    @GetMapping(value={"/", "/v3/websocket"})
    public void oldWebsocket() {
        log.warn("This is the old Lavalink websocket endpoint. Please use /v4/websocket instead. If you are using a client library, please update it to a Lavalink v4 compatible version or use Lavalink v3 instead.");
    }
}

