/*
 * Decompiled with CFR 0.152.
 */
package lavalink.server.info;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import lavalink.server.info.AppInfo;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Llavalink/server/info/AppInfo;", "", "<init>", "()V", "versionBuild", "", "getVersionBuild", "()Ljava/lang/String;", "groupId", "getGroupId", "artifactId", "getArtifactId", "buildTime", "", "getBuildTime", "()J", "Companion", "Lavalink-Server"})
public class AppInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String versionBuild;
    @NotNull
    private final String groupId;
    @NotNull
    private final String artifactId;
    private final long buildTime;
    private static final Logger log = LoggerFactory.getLogger(AppInfo.class);

    public AppInfo() {
        InputStream resourceAsStream = this.getClass().getResourceAsStream("/app.properties");
        Properties prop = new Properties();
        try {
            prop.load(resourceAsStream);
        }
        catch (IOException e) {
            log.error("Failed to load app.properties", (Throwable)e);
        }
        String string = prop.getProperty("version");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        this.versionBuild = string;
        String string2 = prop.getProperty("groupId");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        this.groupId = string2;
        String string3 = prop.getProperty("artifactId");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProperty(...)");
        this.artifactId = string3;
        String string4 = prop.getProperty("buildTime");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getProperty(...)");
        Long l = StringsKt.toLongOrNull((String)string4);
        this.buildTime = l != null ? l : -1L;
    }

    @NotNull
    public final String getVersionBuild() {
        return this.versionBuild;
    }

    @NotNull
    public final String getGroupId() {
        return this.groupId;
    }

    @NotNull
    public final String getArtifactId() {
        return this.artifactId;
    }

    public final long getBuildTime() {
        return this.buildTime;
    }
}

